// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search.vsm;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of vsmfields
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class VsmfieldsConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "410f27ed212871762b984e362e694c94";
  public final static String CONFIG_DEF_NAME = "vsmfields";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search.vsm";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search.vsm",
    "documentverificationlevel int default=0",
    "searchall int default=1",
    "fieldspec[].name string",
    "fieldspec[].searchmethod enum { NONE, BOOL, AUTOUTF8, UTF8, SSE2UTF8, INT8, INT16, INT32, INT64, FLOAT16, FLOAT, DOUBLE, GEOPOS, NEAREST_NEIGHBOR } default=AUTOUTF8",
    "fieldspec[].arg1 string default=\"\"",
    "fieldspec[].normalize enum { NONE, LOWERCASE, LOWERCASE_AND_FOLD } default=LOWERCASE_AND_FOLD",
    "fieldspec[].maxlength int default=1048576",
    "fieldspec[].fieldtype enum {ATTRIBUTE, INDEX} default=INDEX",
    "documenttype[].name string",
    "documenttype[].index[].name string",
    "documenttype[].index[].field[].name string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer documentverificationlevel = null;
    private Integer searchall = null;
    public List<Fieldspec.Builder> fieldspec = new ArrayList<>();
    public List<Documenttype.Builder> documenttype = new ArrayList<>();

    public Builder() { }

    public Builder(VsmfieldsConfig config) {
      documentverificationlevel(config.documentverificationlevel());
      searchall(config.searchall());
      for (Fieldspec f : config.fieldspec()) {
        fieldspec(new Fieldspec.Builder(f));
      }
      for (Documenttype d : config.documenttype()) {
        documenttype(new Documenttype.Builder(d));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.documentverificationlevel != null)
        documentverificationlevel(__superior.documentverificationlevel);
      if (__superior.searchall != null)
        searchall(__superior.searchall);
      if (!__superior.fieldspec.isEmpty())
        fieldspec.addAll(__superior.fieldspec);
      if (!__superior.documenttype.isEmpty())
        documenttype.addAll(__superior.documenttype);
      return this;
    }

    public Builder documentverificationlevel(int __value) {
      documentverificationlevel = __value;
      return this;
    }

    private Builder documentverificationlevel(String __value) {
      return documentverificationlevel(Integer.valueOf(__value));
    }

    public Builder searchall(int __value) {
      searchall = __value;
      return this;
    }

    private Builder searchall(String __value) {
      return searchall(Integer.valueOf(__value));
    }

    /**
     * Add the given builder to this builder's list of Fieldspec builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder fieldspec(Fieldspec.Builder __builder) {
      fieldspec.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder fieldspec(java.util.function.Consumer<Fieldspec.Builder> __func) {
      Fieldspec.Builder __inner = new Fieldspec.Builder();
      __func.accept(__inner);
      fieldspec.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Fieldspec builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder fieldspec(List<Fieldspec.Builder> __builders) {
      fieldspec = __builders;
      return this;
    }

    /**
     * Add the given builder to this builder's list of Documenttype builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder documenttype(Documenttype.Builder __builder) {
      documenttype.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder documenttype(java.util.function.Consumer<Documenttype.Builder> __func) {
      Documenttype.Builder __inner = new Documenttype.Builder();
      __func.accept(__inner);
      documenttype.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Documenttype builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder documenttype(List<Documenttype.Builder> __builders) {
      documenttype = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public VsmfieldsConfig build() {
      return new VsmfieldsConfig(this);
    }

  }

  // Level of verification applied to the documents received.
  private final IntegerNode documentverificationlevel;
  // Set if one should ignore limit hits.
  private final IntegerNode searchall;
  private final InnerNodeVector<Fieldspec> fieldspec;
  private final InnerNodeVector<Documenttype> documenttype;

  public VsmfieldsConfig(Builder builder) {
    this(builder, true);
  }

  private VsmfieldsConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "vsmfields must be initialized: " + builder.__uninitialized);

    documentverificationlevel = (builder.documentverificationlevel == null) ?
        new IntegerNode(0) : new IntegerNode(builder.documentverificationlevel);
    searchall = (builder.searchall == null) ?
        new IntegerNode(1) : new IntegerNode(builder.searchall);
    fieldspec = Fieldspec.createVector(builder.fieldspec);
    documenttype = Documenttype.createVector(builder.documenttype);
  }

  /**
   * @return vsmfields.documentverificationlevel
   */
  public int documentverificationlevel() {
    return documentverificationlevel.value();
  }

  /**
   * @return vsmfields.searchall
   */
  public int searchall() {
    return searchall.value();
  }

  /**
   * @return vsmfields.fieldspec[]
   */
  public List<Fieldspec> fieldspec() {
    return fieldspec;
  }

  /**
   * @param i the index of the value to return
   * @return vsmfields.fieldspec[]
   */
  public Fieldspec fieldspec(int i) {
    return fieldspec.get(i);
  }

  /**
   * @return vsmfields.documenttype[]
   */
  public List<Documenttype> documenttype() {
    return documenttype;
  }

  /**
   * @param i the index of the value to return
   * @return vsmfields.documenttype[]
   */
  public Documenttype documenttype(int i) {
    return documenttype.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(VsmfieldsConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("vsmfields");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents vsmfields.fieldspec[]
   */
  public final static class Fieldspec extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      private Searchmethod.Enum searchmethod = null;
      private String arg1 = null;
      private Normalize.Enum normalize = null;
      private Integer maxlength = null;
      private Fieldtype.Enum fieldtype = null;

      public Builder() { }

      public Builder(Fieldspec config) {
        name(config.name());
        searchmethod(config.searchmethod());
        arg1(config.arg1());
        normalize(config.normalize());
        maxlength(config.maxlength());
        fieldtype(config.fieldtype());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.searchmethod != null)
          searchmethod(__superior.searchmethod);
        if (__superior.arg1 != null)
          arg1(__superior.arg1);
        if (__superior.normalize != null)
          normalize(__superior.normalize);
        if (__superior.maxlength != null)
          maxlength(__superior.maxlength);
        if (__superior.fieldtype != null)
          fieldtype(__superior.fieldtype);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder searchmethod(Searchmethod.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        searchmethod = __value;
        return this;
      }

      private Builder searchmethod(String __value) {
        return searchmethod(Searchmethod.Enum.valueOf(__value));
      }

      public Builder arg1(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        arg1 = __value;
        return this;
      }


      public Builder normalize(Normalize.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        normalize = __value;
        return this;
      }

      private Builder normalize(String __value) {
        return normalize(Normalize.Enum.valueOf(__value));
      }

      public Builder maxlength(int __value) {
        maxlength = __value;
        return this;
      }

      private Builder maxlength(String __value) {
        return maxlength(Integer.valueOf(__value));
      }

      public Builder fieldtype(Fieldtype.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        fieldtype = __value;
        return this;
      }

      private Builder fieldtype(String __value) {
        return fieldtype(Fieldtype.Enum.valueOf(__value));
      }

      public Fieldspec build() {
        return new Fieldspec(this);
      }

    }

    // The name of a field for which we are assigning a search method.
    // The field name refers directly to a field in the document model.
    private final StringNode name;
    // The search method for a given field. Note: same field in 2 different document types must match on type if not a random result might be expected.
    private final Searchmethod searchmethod;
    private final StringNode arg1;
    private final Normalize normalize;
    // Maximum number of chars to search per field.
    private final IntegerNode maxlength;
    // Type of the field
    private final Fieldtype fieldtype;

    public Fieldspec(Builder builder) {
      this(builder, true);
    }

    private Fieldspec(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "vsmfields.fieldspec[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      searchmethod = (builder.searchmethod == null) ?
          new Searchmethod(Searchmethod.AUTOUTF8) : new Searchmethod(builder.searchmethod);
      arg1 = (builder.arg1 == null) ?
          new StringNode("") : new StringNode(builder.arg1);
      normalize = (builder.normalize == null) ?
          new Normalize(Normalize.LOWERCASE_AND_FOLD) : new Normalize(builder.normalize);
      maxlength = (builder.maxlength == null) ?
          new IntegerNode(1048576) : new IntegerNode(builder.maxlength);
      fieldtype = (builder.fieldtype == null) ?
          new Fieldtype(Fieldtype.INDEX) : new Fieldtype(builder.fieldtype);
    }

    /**
     * @return vsmfields.fieldspec[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return vsmfields.fieldspec[].searchmethod
     */
    public Searchmethod.Enum searchmethod() {
      return searchmethod.value();
    }

    /**
     * @return vsmfields.fieldspec[].arg1
     */
    public String arg1() {
      return arg1.value();
    }

    /**
     * @return vsmfields.fieldspec[].normalize
     */
    public Normalize.Enum normalize() {
      return normalize.value();
    }

    /**
     * @return vsmfields.fieldspec[].maxlength
     */
    public int maxlength() {
      return maxlength.value();
    }

    /**
     * @return vsmfields.fieldspec[].fieldtype
     */
    public Fieldtype.Enum fieldtype() {
      return fieldtype.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Fieldspec newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldspec");
      return changes;
    }

    private static InnerNodeVector<Fieldspec> createVector(List<Builder> builders) {
        List<Fieldspec> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Fieldspec(b));
        }
        return new InnerNodeVector<Fieldspec>(elems);
    }

    /**
     * This class represents vsmfields.fieldspec[].searchmethod
     * 
     * The search method for a given field. Note: same field in 2 different document types must match on type if not a random result might be expected.
     */
    public final static class Searchmethod extends EnumNode<Searchmethod.Enum> {

      public Searchmethod(){
        this.value = null;
      }

      public Searchmethod(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {NONE, BOOL, AUTOUTF8, UTF8, SSE2UTF8, INT8, INT16, INT32, INT64, FLOAT16, FLOAT, DOUBLE, GEOPOS, NEAREST_NEIGHBOR}
      public final static Enum NONE = Enum.NONE;
      public final static Enum BOOL = Enum.BOOL;
      public final static Enum AUTOUTF8 = Enum.AUTOUTF8;
      public final static Enum UTF8 = Enum.UTF8;
      public final static Enum SSE2UTF8 = Enum.SSE2UTF8;
      public final static Enum INT8 = Enum.INT8;
      public final static Enum INT16 = Enum.INT16;
      public final static Enum INT32 = Enum.INT32;
      public final static Enum INT64 = Enum.INT64;
      public final static Enum FLOAT16 = Enum.FLOAT16;
      public final static Enum FLOAT = Enum.FLOAT;
      public final static Enum DOUBLE = Enum.DOUBLE;
      public final static Enum GEOPOS = Enum.GEOPOS;
      public final static Enum NEAREST_NEIGHBOR = Enum.NEAREST_NEIGHBOR;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents vsmfields.fieldspec[].normalize
     */
    public final static class Normalize extends EnumNode<Normalize.Enum> {

      public Normalize(){
        this.value = null;
      }

      public Normalize(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {NONE, LOWERCASE, LOWERCASE_AND_FOLD}
      public final static Enum NONE = Enum.NONE;
      public final static Enum LOWERCASE = Enum.LOWERCASE;
      public final static Enum LOWERCASE_AND_FOLD = Enum.LOWERCASE_AND_FOLD;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents vsmfields.fieldspec[].fieldtype
     * 
     * Type of the field
     */
    public final static class Fieldtype extends EnumNode<Fieldtype.Enum> {

      public Fieldtype(){
        this.value = null;
      }

      public Fieldtype(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {ATTRIBUTE, INDEX}
      public final static Enum ATTRIBUTE = Enum.ATTRIBUTE;
      public final static Enum INDEX = Enum.INDEX;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }
  }

  /**
   * This class represents vsmfields.documenttype[]
   */
  public final static class Documenttype extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      public List<Index.Builder> index = new ArrayList<>();

      public Builder() { }

      public Builder(Documenttype config) {
        name(config.name());
        for (Index i : config.index()) {
          index(new Index.Builder(i));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (!__superior.index.isEmpty())
          index.addAll(__superior.index);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      /**
       * Add the given builder to this builder's list of Index builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder index(Index.Builder __builder) {
        index.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder index(java.util.function.Consumer<Index.Builder> __func) {
        Index.Builder __inner = new Index.Builder();
        __func.accept(__inner);
        index.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Index builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder index(List<Index.Builder> __builders) {
        index = __builders;
        return this;
      }

      public Documenttype build() {
        return new Documenttype(this);
      }

    }

    // The name of a documenttype for which we are assigning a set of indexes.
    private final StringNode name;
    private final InnerNodeVector<Index> index;

    public Documenttype(Builder builder) {
      this(builder, true);
    }

    private Documenttype(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "vsmfields.documenttype[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      index = Index.createVector(builder.index);
    }

    /**
     * @return vsmfields.documenttype[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return vsmfields.documenttype[].index[]
     */
    public List<Index> index() {
      return index;
    }

    /**
     * @param i the index of the value to return
     * @return vsmfields.documenttype[].index[]
     */
    public Index index(int i) {
      return index.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Documenttype newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("documenttype");
      return changes;
    }

    private static InnerNodeVector<Documenttype> createVector(List<Builder> builders) {
        List<Documenttype> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Documenttype(b));
        }
        return new InnerNodeVector<Documenttype>(elems);
    }

    /**
     * This class represents vsmfields.documenttype[].index[]
     */
    public final static class Index extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name"
          ));

        private String name = null;
        public List<Field.Builder> field = new ArrayList<>();

        public Builder() { }

        public Builder(Index config) {
          name(config.name());
          for (Field f : config.field()) {
            field(new Field.Builder(f));
          }
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (!__superior.field.isEmpty())
            field.addAll(__superior.field);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        /**
         * Add the given builder to this builder's list of Field builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder field(Field.Builder __builder) {
          field.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder field(java.util.function.Consumer<Field.Builder> __func) {
          Field.Builder __inner = new Field.Builder();
          __func.accept(__inner);
          field.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Field builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder field(List<Field.Builder> __builders) {
          field = __builders;
          return this;
        }

        public Index build() {
          return new Index(this);
        }

      }

      // The name of an index of a documenttype for which we are assigning a set of fields.
      private final StringNode name;
      private final InnerNodeVector<Field> field;

      public Index(Builder builder) {
        this(builder, true);
      }

      private Index(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "vsmfields.documenttype[].index[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        field = Field.createVector(builder.field);
      }

      /**
       * @return vsmfields.documenttype[].index[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return vsmfields.documenttype[].index[].field[]
       */
      public List<Field> field() {
        return field;
      }

      /**
       * @param i the index of the value to return
       * @return vsmfields.documenttype[].index[].field[]
       */
      public Field field(int i) {
        return field.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Index newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("index");
        return changes;
      }

      private static InnerNodeVector<Index> createVector(List<Builder> builders) {
          List<Index> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Index(b));
          }
          return new InnerNodeVector<Index>(elems);
      }

      /**
       * This class represents vsmfields.documenttype[].index[].field[]
       */
      public final static class Field extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "name"
            ));

          private String name = null;

          public Builder() { }

          public Builder(Field config) {
            name(config.name());
          }

          private Builder override(Builder __superior) {
            if (__superior.name != null)
              name(__superior.name);
            return this;
          }

          public Builder name(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            name = __value;
            __uninitialized.remove("name");
            return this;
          }


          public Field build() {
            return new Field(this);
          }

        }

        // The name of a field part of an index.
        // The field name refers directly to a field in the document model.
        private final StringNode name;

        public Field(Builder builder) {
          this(builder, true);
        }

        private Field(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "vsmfields.documenttype[].index[].field[] must be initialized: " + builder.__uninitialized);

          name = (builder.name == null) ?
              new StringNode() : new StringNode(builder.name);
        }

        /**
         * @return vsmfields.documenttype[].index[].field[].name
         */
        public String name() {
          return name.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
          return changes;
        }

        private static InnerNodeVector<Field> createVector(List<Builder> builders) {
            List<Field> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Field(b));
            }
            return new InnerNodeVector<Field>(elems);
        }
      }
    }
  }

}
