// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search.vsm;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of vsm
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class VsmConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "418301f17a08ba858242b3094b00b8dc";
  public final static String CONFIG_DEF_NAME = "vsm";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search.vsm";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search.vsm",
    "doctype reference",
    "storagecfg reference",
    "vsmfields reference"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "doctype",
      "storagecfg",
      "vsmfields"
      ));

    private String doctype = null;
    private String storagecfg = null;
    private String vsmfields = null;

    public Builder() { }

    public Builder(VsmConfig config) {
      doctype(config.doctype());
      storagecfg(config.storagecfg());
      vsmfields(config.vsmfields());
    }

    private Builder override(Builder __superior) {
      if (__superior.doctype != null)
        doctype(__superior.doctype);
      if (__superior.storagecfg != null)
        storagecfg(__superior.storagecfg);
      if (__superior.vsmfields != null)
        vsmfields(__superior.vsmfields);
      return this;
    }

    public Builder doctype(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      doctype = __value;
      __uninitialized.remove("doctype");
      return this;
    }


    public Builder storagecfg(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      storagecfg = __value;
      __uninitialized.remove("storagecfg");
      return this;
    }


    public Builder vsmfields(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      vsmfields = __value;
      __uninitialized.remove("vsmfields");
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public VsmConfig build() {
      return new VsmConfig(this);
    }

  }

  // The document model for the documents used as input for the VSM
  private final ReferenceNode doctype;
  // Configuration for storage client used by VSM
  private final ReferenceNode storagecfg;
  // Config defining what search method should be applied to different
  // fields in the documents. It also contains a mapping from index name
  // to a set of fields making up that index.
  private final ReferenceNode vsmfields;

  public VsmConfig(Builder builder) {
    this(builder, true);
  }

  private VsmConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "vsm must be initialized: " + builder.__uninitialized);

    doctype = (builder.doctype == null) ?
        new ReferenceNode() : new ReferenceNode(builder.doctype);
    storagecfg = (builder.storagecfg == null) ?
        new ReferenceNode() : new ReferenceNode(builder.storagecfg);
    vsmfields = (builder.vsmfields == null) ?
        new ReferenceNode() : new ReferenceNode(builder.vsmfields);
  }

  /**
   * @return vsm.doctype
   */
  public String doctype() {
    return doctype.value();
  }

  /**
   * @return vsm.storagecfg
   */
  public String storagecfg() {
    return storagecfg.value();
  }

  /**
   * @return vsm.vsmfields
   */
  public String vsmfields() {
    return vsmfields.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(VsmConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("vsm");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
