/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import com.yahoo.log.LevelController;
import com.yahoo.log.LogLevel;
import com.yahoo.text.Utf8;
import java.nio.MappedByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

class MappedLevelController
implements LevelController {
    private static final int ONVAL = 538988366;
    private static final int OFFVAL = 542066246;
    private MappedByteBuffer mapBuf;
    private int offset;
    private Logger associate;

    public MappedLevelController(MappedByteBuffer buf, int firstoffset, String name) {
        this.mapBuf = buf;
        this.offset = firstoffset;
        this.associate = Logger.getLogger(name);
    }

    @Override
    public String getOnOffString() {
        byte[] levels = new byte[32];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = this.mapBuf.get(this.offset + i);
        }
        return Utf8.toString((byte[])levels);
    }

    public static boolean checkOnOff(MappedByteBuffer mapBuf, int offset) {
        for (int i = 0; i < 8; ++i) {
            int off = offset + 4 * i;
            int val = mapBuf.getInt(off);
            if (val == 538988366 || val == 542066246) continue;
            System.err.println("bad on/off value: " + val);
            return false;
        }
        return true;
    }

    @Override
    public void checkBack() {
        this.associate.setLevel(this.getLevelLimit());
    }

    @Override
    public Level getLevelLimit() {
        Level lvl = this.isOn(7) ? LogLevel.ALL : (this.isOn(6) ? LogLevel.FINE : (this.isOn(3) ? LogLevel.CONFIG : (this.isOn(4) ? LogLevel.INFO : (this.isOn(2) ? LogLevel.WARNING : LogLevel.SEVERE))));
        return lvl;
    }

    private boolean isOn(int num) {
        int off = this.offset + num * 4;
        int val = this.mapBuf.getInt(off);
        return val != 542066246;
    }

    @Override
    public boolean shouldLog(Level level) {
        int val = level.intValue();
        if (val == 1201) {
            return this.isOn(5);
        }
        if (val >= 1161) {
            return this.isOn(0);
        }
        if (val >= 1000) {
            return this.isOn(1);
        }
        if (val >= 900) {
            return this.isOn(2);
        }
        if (val >= 800) {
            return this.isOn(4);
        }
        if (val >= 700) {
            return this.isOn(3);
        }
        if (val >= 400) {
            return this.isOn(6);
        }
        return this.isOn(7);
    }
}

