/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import com.yahoo.log.LogTarget;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class FileLogTarget
implements LogTarget {
    private final File file;
    private FileOutputStream fileOutputStream;

    public FileLogTarget(File target) throws FileNotFoundException {
        this.file = target;
        this.fileOutputStream = null;
    }

    @Override
    public synchronized OutputStream open() {
        try {
            this.close();
            this.fileOutputStream = new FileOutputStream(this.file, true);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Unable to open output stream", e);
        }
        return this.fileOutputStream;
    }

    @Override
    public synchronized void close() {
        try {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.close();
                this.fileOutputStream = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to close output stream", e);
        }
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }
}

