/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.system;

import com.yahoo.collections.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ProcessExecuter {
    private final boolean override_log_control;

    public ProcessExecuter(boolean override_log_control) {
        this.override_log_control = override_log_control;
    }

    public ProcessExecuter() {
        this(false);
    }

    public Pair<Integer, String> exec(String command) throws IOException {
        StringTokenizer tok = new StringTokenizer(command);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tok.hasMoreElements()) {
            tokens.add(tok.nextToken());
        }
        return this.exec(tokens.toArray(new String[0]));
    }

    public Pair<Integer, String> exec(String[] command) throws IOException {
        int b;
        ProcessBuilder pb = new ProcessBuilder(command);
        StringBuilder ret = new StringBuilder();
        pb.environment().remove("VESPA_LOG_TARGET");
        if (this.override_log_control) {
            pb.environment().remove("VESPA_LOG_CONTROL_FILE");
            pb.environment().put("VESPA_SERVICE_NAME", "exec-" + command[0]);
        }
        pb.redirectErrorStream(true);
        Process p = pb.start();
        InputStream is = p.getInputStream();
        while ((b = is.read()) != -1) {
            ret.append((char)b);
        }
        int rc = 0;
        try {
            rc = p.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return new Pair<Integer, String>(rc, ret.toString());
    }
}

