/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;

public abstract class IOUtils {
    private static final Charset utf8Charset = StandardCharsets.UTF_8;

    public static void closeWriter(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeReader(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeInputStream(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeOutputStream(OutputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static BufferedReader createReader(File filename, String encoding) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
    }

    public static BufferedReader createReader(String filename, String encoding) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
    }

    public static BufferedReader createReader(String filename) throws IOException {
        return new BufferedReader(new FileReader(filename));
    }

    public static BufferedWriter createWriter(String filename, String encoding, boolean append) throws IOException {
        IOUtils.createDirectory(filename);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, append), encoding));
    }

    public static BufferedWriter createWriter(File file, String encoding, boolean append) throws IOException {
        IOUtils.createDirectory(file.getAbsolutePath());
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), encoding));
    }

    public static BufferedWriter createWriter(String filename, boolean append) throws IOException {
        IOUtils.createDirectory(filename);
        return new BufferedWriter(new FileWriter(filename, append));
    }

    public static BufferedWriter createWriter(File file, boolean append) throws IOException {
        IOUtils.createDirectory(file.getAbsolutePath());
        return new BufferedWriter(new FileWriter(file, append));
    }

    public static void createDirectory(String filename) {
        File directory = new File(filename).getParentFile();
        if (directory != null) {
            directory.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String inFile, String outFile, int lineCount) throws IOException {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            int c;
            reader = IOUtils.createReader(inFile);
            writer = IOUtils.createWriter(outFile, false);
            int newLines = 0;
            while (-1 != (c = reader.read()) && newLines < lineCount) {
                writer.write(c);
                if (c != 10) continue;
                ++newLines;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeReader(reader);
            IOUtils.closeWriter(writer);
            throw throwable;
        }
        IOUtils.closeReader(reader);
        IOUtils.closeWriter(writer);
    }

    public static void copy(String inFile, String outFile) throws IOException {
        IOUtils.copy(new File(inFile), new File(outFile));
    }

    public static void copy(File inFile, File outFile) throws IOException {
        try (FileChannel sourceChannel = new FileInputStream(inFile).getChannel();
             FileChannel destChannel = new FileOutputStream(outFile).getChannel();){
            destChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
    }

    public static void copyDirectory(File sourceLocation, File targetLocation, int maxRecurseLevel) throws IOException {
        IOUtils.copyDirectory(sourceLocation, targetLocation, maxRecurseLevel, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectory(File sourceLocation, File targetLocation, int maxRecurseLevel, FilenameFilter filter) throws IOException {
        block8: {
            block7: {
                if (!sourceLocation.exists()) {
                    throw new IllegalArgumentException(sourceLocation.getAbsolutePath() + " does not exist");
                }
                if (sourceLocation.isDirectory()) break block7;
                FileInputStream in = null;
                FileOutputStream out = null;
                try {
                    int len;
                    in = new FileInputStream(sourceLocation);
                    out = new FileOutputStream(targetLocation);
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeInputStream(in);
                    IOUtils.closeOutputStream(out);
                    throw throwable;
                }
                IOUtils.closeInputStream(in);
                IOUtils.closeOutputStream(out);
                break block8;
            }
            if (maxRecurseLevel != 0) {
                if (!targetLocation.exists()) {
                    targetLocation.mkdirs();
                }
                String[] children = sourceLocation.list(filter);
                for (int i = 0; i < children.length; ++i) {
                    IOUtils.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]), maxRecurseLevel - 1);
                }
            }
        }
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        IOUtils.copyDirectory(sourceLocation, targetLocation, -1);
    }

    public static void copyDirectoryInto(File sourceLocation, File targetLocation) throws IOException {
        File destination = new File(targetLocation, sourceLocation.getAbsoluteFile().getName());
        IOUtils.copyDirectory(sourceLocation, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countLines(String file) {
        BufferedReader reader = null;
        int lineCount = 0;
        try {
            reader = IOUtils.createReader(file, "utf8");
            while (reader.readLine() != null) {
                ++lineCount;
            }
            int n = lineCount;
            return n;
        }
        catch (IOException e) {
            int n = lineCount;
            return n;
        }
        finally {
            IOUtils.closeReader(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getLines(String fileName) throws IOException {
        ArrayList<String> arrayList;
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            reader = IOUtils.createReader(fileName, "utf8");
            while (null != (line = reader.readLine())) {
                lines.add(line);
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            IOUtils.closeReader(reader);
            throw throwable;
        }
        IOUtils.closeReader(reader);
        return arrayList;
    }

    public static boolean recursiveDeleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String child : children = dir.list()) {
                boolean success = IOUtils.recursiveDeleteDir(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static ByteBuffer utf8ByteBuffer(String s) {
        return utf8Charset.encode(s);
    }

    public static String readFile(File file) throws IOException {
        try {
            if (file == null) {
                return null;
            }
            return Files.readString(file.toPath(), utf8Charset);
        }
        catch (NoSuchFileException e) {
            throw new NoSuchFileException("Could not find file '" + file.getAbsolutePath() + "'");
        }
    }

    public static byte[] readBytes(InputStream stream, int chunkSize) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[chunkSize];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static byte[] readFileBytes(File file) throws IOException {
        long lengthL = file.length();
        if (lengthL > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big for byte array: " + file.getCanonicalPath());
        }
        try (FileInputStream in = new FileInputStream(file);){
            int length = (int)lengthL;
            byte[] array = new byte[length];
            int count = 0;
            for (int offset = 0; offset < length && (count = ((InputStream)in).read(array, offset, length - offset)) >= 0; offset += count) {
            }
            byte[] byArray = array;
            return byArray;
        }
    }

    public static String readAll(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader buffered = new BufferedReader(reader);){
            int c;
            while ((c = buffered.read()) != -1) {
                sb.append((char)c);
            }
        }
        return sb.toString();
    }

    public static String readAll(InputStream stream, Charset charset) throws IOException {
        return new String(stream.readAllBytes(), charset);
    }

    public static void closeAll(List<Reader> readers) {
        if (readers == null) {
            return;
        }
        for (Reader reader : readers) {
            IOUtils.closeReader(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String text, boolean append) throws IOException {
        BufferedWriter out = null;
        try {
            out = IOUtils.createWriter(file, append);
            out.write(text);
        }
        finally {
            IOUtils.closeWriter(out);
        }
    }

    public static void writeFile(File file, byte[] content) throws UncheckedIOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(content);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeFile(String file, String text, boolean append) throws IOException {
        IOUtils.writeFile(new File(file), text, append);
    }
}

