/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.data.disclosure.slime;

import com.yahoo.data.disclosure.DataSink;
import com.yahoo.data.disclosure.DataSource;
import com.yahoo.slime.ArrayInserter;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inserter;
import com.yahoo.slime.ObjectInserter;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeInserter;
import com.yahoo.slime.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;

public class SlimeDataSink
implements DataSink {
    private Inserter rootInserter;
    private Deque<Cursor> stack = new ArrayDeque<Cursor>();
    private String key;

    public SlimeDataSink(Inserter inserter) {
        this.rootInserter = inserter;
    }

    public static Slime buildSlime(DataSource source) {
        Slime slime = new Slime();
        SlimeInserter inserter = new SlimeInserter(slime);
        SlimeDataSink sink = new SlimeDataSink(inserter);
        source.emit(sink);
        return slime;
    }

    private Inserter makeInserter() {
        if (this.stack.isEmpty()) {
            return this.rootInserter;
        }
        if (this.stack.peek().type() == Type.OBJECT) {
            return new ObjectInserter(this.stack.peek(), this.key);
        }
        return new ArrayInserter(this.stack.peek());
    }

    @Override
    public void fieldName(String utf16, byte[] utf8) {
        this.key = utf16 != null ? utf16 : new String(utf8, StandardCharsets.UTF_8);
    }

    @Override
    public void startObject() {
        this.stack.push(this.makeInserter().insertOBJECT());
    }

    @Override
    public void endObject() {
        if (!this.stack.isEmpty()) {
            this.stack.pop();
        }
    }

    @Override
    public void startArray() {
        this.stack.push(this.makeInserter().insertARRAY());
    }

    @Override
    public void endArray() {
        if (!this.stack.isEmpty()) {
            this.stack.pop();
        }
    }

    @Override
    public void emptyValue() {
        this.makeInserter().insertNIX();
    }

    @Override
    public void booleanValue(boolean v) {
        this.makeInserter().insertBOOL(v);
    }

    @Override
    public void longValue(long v) {
        this.makeInserter().insertLONG(v);
    }

    @Override
    public void doubleValue(double v) {
        this.makeInserter().insertDOUBLE(v);
    }

    @Override
    public void stringValue(String utf16, byte[] utf8) {
        String v = utf16 != null ? utf16 : new String(utf8, StandardCharsets.UTF_8);
        this.makeInserter().insertSTRING(v);
    }

    @Override
    public void dataValue(byte[] data) {
        this.makeInserter().insertDATA(data);
    }
}

