/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent;

import com.yahoo.concurrent.Lock;
import com.yahoo.concurrent.UncheckedTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class Locks<TYPE> {
    private final Map<TYPE, ReentrantLock> locks = new ConcurrentHashMap<TYPE, ReentrantLock>();
    private final long timeoutMs;

    public Locks(long timeout, TimeUnit timeoutUnit) {
        this.timeoutMs = timeoutUnit.toMillis(timeout);
    }

    public Lock lock(TYPE key) {
        return this.lock(key, this.timeoutMs, TimeUnit.MILLISECONDS);
    }

    public Lock lock(TYPE key, long timeout, TimeUnit timeoutUnit) {
        try {
            ReentrantLock lock = this.locks.computeIfAbsent(key, k -> new ReentrantLock(true));
            boolean acquired = lock.tryLock(timeout, timeoutUnit);
            if (!acquired) {
                throw new UncheckedTimeoutException("Timed out waiting for the lock to " + String.valueOf(key));
            }
            return new Lock(lock);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for lock of " + String.valueOf(key));
        }
    }
}

