/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.text.Identifier;
import com.yahoo.text.Utf8;
import com.yahoo.text.Utf8Array;
import com.yahoo.text.Utf8String;

public class LowercaseIdentifier
extends Identifier {
    public LowercaseIdentifier(String s) {
        this(Utf8.toBytes(s));
    }

    public LowercaseIdentifier(AbstractUtf8Array utf8) {
        this(utf8.getBytes());
    }

    public LowercaseIdentifier(byte[] utf8) {
        super(LowercaseIdentifier.verify(utf8));
    }

    private static byte[] verify(byte[] utf8) {
        for (int i = 0; i < utf8.length; ++i) {
            LowercaseIdentifier.verifyAny(utf8[i], utf8);
        }
        return utf8;
    }

    private static boolean verifyAny(byte c, byte[] identifier) {
        if (c >= 65 && c <= 90) {
            throw new IllegalArgumentException("Illegal uppercase character '" + (char)c + "' of identifier '" + new Utf8String(new Utf8Array(identifier)).toString() + "'.");
        }
        return true;
    }
}

