/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.impl;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.yahoo.tensor.Label;

class LabelImpl
implements Label {
    private static final HashFunction hashFunction = Hashing.murmur3_32_fixed();
    private final long numeric;
    private final String string;
    private final int hashCode;

    LabelImpl(long numeric) {
        this.numeric = numeric;
        this.string = null;
        this.hashCode = hashFunction.hashLong(numeric).asInt();
    }

    LabelImpl(long numeric, String string) {
        this.numeric = numeric;
        this.string = string;
        this.hashCode = hashFunction.hashLong(numeric).asInt();
    }

    @Override
    public long asNumeric() {
        return this.numeric;
    }

    @Override
    public String asString() {
        if (this.numeric == -1L) {
            return null;
        }
        if (this.string == null) {
            return String.valueOf(this.numeric);
        }
        return this.string;
    }

    @Override
    public boolean isEqualTo(Label label) {
        return this.asNumeric() == label.asNumeric();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LabelImpl label = (LabelImpl)object;
        return this.isEqualTo(label);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

