/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.MapEvaluationContext;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.TensorFunction;

class DenseSubspaceFunction<NAMETYPE extends Name> {
    private final String argName;
    private final TensorFunction<NAMETYPE> function;

    public DenseSubspaceFunction(String argName, TensorFunction<NAMETYPE> function) {
        this.argName = argName;
        this.function = function;
    }

    Tensor map(Tensor subspace) {
        MapEvaluationContext context = new MapEvaluationContext();
        context.put(this.argName, subspace);
        return this.function.evaluate(context);
    }

    DenseSubspaceFunction<NAMETYPE> toPrimitive() {
        return new DenseSubspaceFunction<NAMETYPE>(this.argName, this.function.toPrimitive());
    }

    TensorType outputType(TensorType subspaceType) {
        MyTypeContext context = new MyTypeContext(subspaceType);
        TensorType result = this.function.type(context);
        return result;
    }

    public String toString() {
        return "f(" + this.argName + ")(" + String.valueOf(this.function) + ")";
    }

    class MyTypeContext
    implements TypeContext<NAMETYPE> {
        private final TensorType subspaceType;

        MyTypeContext(TensorType subspaceType) {
            this.subspaceType = subspaceType;
        }

        @Override
        public TensorType getType(NAMETYPE name) {
            return this.getType(((Name)name).name());
        }

        @Override
        public TensorType getType(String name) {
            return DenseSubspaceFunction.this.argName.equals(name) ? this.subspaceType : null;
        }

        @Override
        public String resolveBinding(String name) {
            return name;
        }
    }
}

