/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.ArrayInserter;
import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inserter;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.ObjectInserter;
import com.yahoo.slime.ObjectTraverser;
import com.yahoo.slime.Visitor;

public class Injector {
    public void inject(Inspector inspector, Inserter inserter) {
        if (inspector.valid()) {
            this.injectValue(inserter, inspector, null);
        }
    }

    private void injectValue(final Inserter inserter, Inspector inspector, final Inspector guard) {
        inspector.accept(new Visitor(){

            @Override
            public void visitInvalid() {
            }

            @Override
            public void visitNix() {
                inserter.insertNIX();
            }

            @Override
            public void visitBool(boolean bit) {
                inserter.insertBOOL(bit);
            }

            @Override
            public void visitLong(long l) {
                inserter.insertLONG(l);
            }

            @Override
            public void visitDouble(double d) {
                inserter.insertDOUBLE(d);
            }

            @Override
            public void visitString(String str) {
                inserter.insertSTRING(str);
            }

            @Override
            public void visitString(byte[] utf8) {
                inserter.insertSTRING(utf8);
            }

            @Override
            public void visitData(byte[] data) {
                inserter.insertDATA(data);
            }

            @Override
            public void visitArray(Inspector arr) {
                Cursor cursor = inserter.insertARRAY();
                NestedInjector arrayTraverser = new NestedInjector(cursor, guard != null ? guard : cursor);
                arr.traverse(arrayTraverser);
            }

            @Override
            public void visitObject(Inspector obj) {
                Cursor cursor = inserter.insertOBJECT();
                NestedInjector objectTraverser = new NestedInjector(cursor, guard != null ? guard : cursor);
                obj.traverse(objectTraverser);
            }
        });
    }

    private class NestedInjector
    implements ArrayTraverser,
    ObjectTraverser {
        private final Cursor cursor;
        private final Inspector guard;

        public NestedInjector(Cursor cursor, Inspector guard) {
            this.cursor = cursor;
            this.guard = guard;
        }

        @Override
        public void entry(int idx, Inspector inspector) {
            if (inspector == this.guard) {
                return;
            }
            Injector.this.injectValue(new ArrayInserter(this.cursor), inspector, this.guard);
        }

        @Override
        public void field(String name, Inspector inspector) {
            if (inspector == this.guard) {
                return;
            }
            Injector.this.injectValue(new ObjectInserter(this.cursor, name), inspector, this.guard);
        }
    }
}

