/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TensorTypeParser {
    private static final String START_STRING = "tensor";
    private static final String END_STRING = ")";
    private static final Pattern indexedPattern = Pattern.compile("(\\w+)\\[(\\d*)\\]");
    private static final Pattern mappedPattern = Pattern.compile("(\\w+)\\{\\}");

    public static TensorType fromSpec(String specString) {
        return TensorTypeParser.fromSpec(specString, null);
    }

    static TensorType fromSpec(String specString, List<String> dimensionOrder) {
        String dimensionsSpec;
        TensorType.Value valueType;
        if (!(specString = specString.trim()).startsWith(START_STRING) || !specString.endsWith(END_STRING)) {
            throw TensorTypeParser.formatException(specString);
        }
        String specBody = specString.substring(START_STRING.length(), specString.length() - END_STRING.length());
        if (specBody.startsWith("(")) {
            valueType = TensorType.Value.DOUBLE;
            dimensionsSpec = specBody.substring(1);
        } else {
            int parenthesisIndex = specBody.indexOf("(");
            if (parenthesisIndex < 0) {
                throw TensorTypeParser.formatException(specString);
            }
            valueType = TensorTypeParser.parseValueTypeSpec(specBody.substring(0, parenthesisIndex), specString);
            dimensionsSpec = specBody.substring(parenthesisIndex + 1);
        }
        if (dimensionsSpec.isEmpty()) {
            return new TensorType.Builder(valueType, List.of()).build();
        }
        ArrayList<TensorType.Dimension> dimensions = new ArrayList<TensorType.Dimension>();
        for (String element : dimensionsSpec.split(",")) {
            String trimmedElement = element.trim();
            TensorType.Dimension dimension = TensorTypeParser.tryParseIndexedDimension(trimmedElement);
            if (dimension == null) {
                dimension = TensorTypeParser.tryParseMappedDimension(trimmedElement);
            }
            if (dimension == null) {
                throw TensorTypeParser.formatException(specString, "Dimension '" + element + "' is on the wrong format");
            }
            dimensions.add(dimension);
            if (dimensionOrder == null) continue;
            dimensionOrder.add(dimension.name());
        }
        return new TensorType.Builder(valueType, dimensions).build();
    }

    private static TensorType.Value parseValueTypeSpec(String valueTypeSpec, String fullSpecString) {
        if (!valueTypeSpec.startsWith("<") || !valueTypeSpec.endsWith(">")) {
            throw TensorTypeParser.formatException(fullSpecString, Optional.of("Value type spec must be enclosed in <>"));
        }
        try {
            return TensorType.Value.fromId(valueTypeSpec.substring(1, valueTypeSpec.length() - 1));
        }
        catch (IllegalArgumentException e) {
            throw TensorTypeParser.formatException(fullSpecString, e.getMessage());
        }
    }

    private static TensorType.Dimension tryParseIndexedDimension(String element) {
        Matcher matcher = indexedPattern.matcher(element);
        if (matcher.matches()) {
            String dimensionName = matcher.group(1);
            String dimensionSize = matcher.group(2);
            if (dimensionSize.isEmpty()) {
                return TensorType.Dimension.indexed(dimensionName);
            }
            return TensorType.Dimension.indexed(dimensionName, Integer.valueOf(dimensionSize).intValue());
        }
        return null;
    }

    private static TensorType.Dimension tryParseMappedDimension(String element) {
        Matcher matcher = mappedPattern.matcher(element);
        if (matcher.matches()) {
            String dimensionName = matcher.group(1);
            return TensorType.Dimension.mapped(dimensionName);
        }
        return null;
    }

    private static IllegalArgumentException formatException(String spec) {
        return TensorTypeParser.formatException(spec, Optional.empty());
    }

    private static IllegalArgumentException formatException(String spec, String errorDetail) {
        return TensorTypeParser.formatException(spec, Optional.of(errorDetail));
    }

    private static IllegalArgumentException formatException(String spec, Optional<String> errorDetail) {
        throw new IllegalArgumentException("A tensor type spec must be on the form tensor[<valuetype>]?(dimensionidentifier[{}|[length]*), but was '" + spec + "'. " + errorDetail.map(s -> s + ". ").orElse("") + "Examples: tensor(x[3]), tensor<float>(name{}, x[10])");
    }
}

