/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.nativec;

import com.sun.jna.Structure;
import com.yahoo.nativec.NativeC;
import com.yahoo.nativec.NativeHeap;

public class MallInfo
extends NativeHeap {
    private static final Throwable initException = NativeC.loadLibrary(MallInfo.class);
    private final MallInfoStruct mallinfo = MallInfo.mallinfo();

    public static Throwable init() {
        return initException;
    }

    private static native MallInfoStruct.ByValue mallinfo();

    @Override
    public long usedSize() {
        long v = this.mallinfo.uordblks;
        return v << 20;
    }

    @Override
    public long totalSize() {
        long v = this.mallinfo.arena;
        return v << 20;
    }

    @Override
    public long availableSize() {
        long v = this.mallinfo.fordblks;
        return v << 20;
    }

    @Structure.FieldOrder(value={"arena", "ordblks", "smblks", "hblks", "hblkhd", "usmblks", "fsmblks", "uordblks", "fordblks", "keepcost"})
    public static class MallInfoStruct
    extends Structure {
        public int arena;
        public int ordblks;
        public int smblks;
        public int hblks;
        public int hblkhd;
        public int usmblks;
        public int fsmblks;
        public int uordblks;
        public int fordblks;
        public int keepcost;

        public static class ByValue
        extends MallInfoStruct
        implements Structure.ByValue {
        }
    }
}

