/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.TypeResolver;
import com.yahoo.tensor.evaluation.EvaluationContext;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class CellOrder<NAMETYPE extends Name>
extends PrimitiveTensorFunction<NAMETYPE> {
    private final TensorFunction<NAMETYPE> argument;
    private final Order order;

    public CellOrder(TensorFunction<NAMETYPE> argument, Order order) {
        Objects.requireNonNull(argument, "The argument tensor cannot be null");
        Objects.requireNonNull(order, "The order cannot be null");
        this.argument = argument;
        this.order = order;
    }

    public static TensorType outputType(TensorType inputType) {
        return TypeResolver.map(inputType);
    }

    public TensorFunction<NAMETYPE> argument() {
        return this.argument;
    }

    public Order order() {
        return this.order;
    }

    static int nanAwareCompare(double a, double b) {
        if (Double.isNaN(a)) {
            return Double.isNaN(b) ? 0 : 1;
        }
        if (Double.isNaN(b)) {
            return -1;
        }
        return Double.compare(a, b);
    }

    @Override
    public List<TensorFunction<NAMETYPE>> arguments() {
        return List.of(this.argument);
    }

    @Override
    public TensorFunction<NAMETYPE> withArguments(List<TensorFunction<NAMETYPE>> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("CellOrder must have 1 argument, got " + arguments.size());
        }
        return new CellOrder<NAMETYPE>(arguments.get(0), this.order);
    }

    @Override
    public PrimitiveTensorFunction<NAMETYPE> toPrimitive() {
        return new CellOrder<NAMETYPE>(this.argument.toPrimitive(), this.order);
    }

    @Override
    public TensorType type(TypeContext<NAMETYPE> context) {
        return CellOrder.outputType(this.argument.type(context));
    }

    @Override
    public Tensor evaluate(EvaluationContext<NAMETYPE> context) {
        int i;
        Tensor input = this.argument().evaluate(context);
        ArrayList<Double> values = new ArrayList<Double>();
        Iterator<Tensor.Cell> i2 = input.cellIterator();
        while (i2.hasNext()) {
            values.add(i2.next().getValue());
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i3 = 0; i3 < values.size(); ++i3) {
            indexes.add(i3);
        }
        if (this.order == Order.MAX) {
            indexes.sort((a, b) -> CellOrder.nanAwareCompare((Double)values.get((int)b), (Double)values.get((int)a)));
        } else {
            indexes.sort((a, b) -> CellOrder.nanAwareCompare((Double)values.get((int)a), (Double)values.get((int)b)));
        }
        ArrayList<Integer> ranks = new ArrayList<Integer>(indexes.size());
        for (i = 0; i < indexes.size(); ++i) {
            ranks.add(0);
        }
        for (i = 0; i < indexes.size(); ++i) {
            ranks.set((Integer)indexes.get(i), i);
        }
        Tensor.Builder builder = Tensor.Builder.of(CellOrder.outputType(input.type()));
        Iterator<Tensor.Cell> cells = input.cellIterator();
        int i4 = 0;
        while (cells.hasNext()) {
            Tensor.Cell cell = cells.next();
            int rank = (Integer)ranks.get(i4);
            builder.cell(cell.getKey(), (double)rank);
            ++i4;
        }
        return builder.build();
    }

    @Override
    public String toString(ToStringContext<NAMETYPE> context) {
        return "cell_order(" + this.argument.toString(context) + ", " + String.valueOf((Object)this.order) + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{"cell_order", this.argument, this.order});
    }

    public static enum Order {
        MAX,
        MIN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

