/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.exception;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getStackTraceAsString(Throwable throwable) {
        try (StringWriter stringWriter = new StringWriter();){
            PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
            try {
                throwable.printStackTrace(printWriter);
                String string = stringWriter.getBuffer().toString();
                printWriter.close();
                return string;
            }
            catch (Throwable throwable2) {
                try {
                    printWriter.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getStackTraceRecursivelyAsString(Throwable throwable) {
        Throwable cause = throwable;
        try (StringWriter stringWriter = new StringWriter();){
            PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
            try {
                do {
                    cause.printStackTrace(printWriter);
                } while ((cause = cause.getCause()) != null);
                String string = stringWriter.getBuffer().toString();
                printWriter.close();
                return string;
            }
            catch (Throwable throwable2) {
                try {
                    printWriter.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

