/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent.classlock;

import com.yahoo.concurrent.classlock.ClassLock;
import com.yahoo.concurrent.classlock.LockInterruptException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;

public class ClassLocking {
    private final Map<String, ClassLock> classLocks = new HashMap<String, ClassLock>();
    private final Object monitor = new Object();

    public ClassLock lock(Class<?> clazz) {
        return this.lockWhile(clazz, () -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLock lockWhile(Class<?> clazz, BooleanSupplier interruptCondition) {
        Object object = this.monitor;
        synchronized (object) {
            while (this.classLocks.containsKey(clazz.getName())) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (interruptCondition.getAsBoolean()) continue;
                throw new LockInterruptException();
            }
            ClassLock classLock = new ClassLock(this, clazz);
            this.classLocks.put(clazz.getName(), classLock);
            return classLock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock(Class<?> clazz, ClassLock classLock) {
        Object object = this.monitor;
        synchronized (object) {
            if (!classLock.equals(this.classLocks.get(clazz.getName()))) {
                throw new IllegalArgumentException("Lock has already been released");
            }
            this.classLocks.remove(clazz.getName());
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }
}

