/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.objects;

import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.FieldBase;
import com.yahoo.vespa.objects.Serializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BufferSerializer
implements Serializer,
Deserializer {
    protected GrowableByteBuffer buf;

    public BufferSerializer(GrowableByteBuffer buf) {
        this.buf = buf;
    }

    public BufferSerializer(ByteBuffer buf) {
        this(new GrowableByteBuffer(buf));
    }

    public BufferSerializer(byte[] buf) {
        this(ByteBuffer.wrap(buf));
    }

    public BufferSerializer() {
        this(new GrowableByteBuffer());
    }

    public static BufferSerializer wrap(byte[] buf) {
        return new BufferSerializer(buf);
    }

    public final GrowableByteBuffer getBuf() {
        return this.buf;
    }

    protected final void setBuf(GrowableByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public Serializer putByte(FieldBase field, byte value) {
        this.buf.put(value);
        return this;
    }

    @Override
    public Serializer putShort(FieldBase field, short value) {
        this.buf.putShort(value);
        return this;
    }

    @Override
    public Serializer putInt(FieldBase field, int value) {
        this.buf.putInt(value);
        return this;
    }

    @Override
    public Serializer putLong(FieldBase field, long value) {
        this.buf.putLong(value);
        return this;
    }

    @Override
    public Serializer putFloat(FieldBase field, float value) {
        this.buf.putFloat(value);
        return this;
    }

    @Override
    public Serializer putDouble(FieldBase field, double value) {
        this.buf.putDouble(value);
        return this;
    }

    @Override
    public Serializer put(FieldBase field, byte[] value) {
        this.buf.put(value);
        return this;
    }

    @Override
    public Serializer put(FieldBase field, String value) {
        byte[] utf8 = BufferSerializer.createUTF8CharArray(value);
        this.putInt(null, utf8.length + 1);
        this.put(null, utf8);
        this.putByte(null, (byte)0);
        return this;
    }

    @Override
    public Serializer put(FieldBase field, ByteBuffer value) {
        this.buf.put(value);
        return this;
    }

    public Serializer putInt1_4Bytes(FieldBase field, int value) {
        this.buf.putInt1_4Bytes(value);
        return this;
    }

    public Serializer putInt2_4_8Bytes(FieldBase field, long value) {
        this.buf.putInt2_4_8Bytes(value);
        return this;
    }

    public int position() {
        return this.buf.position();
    }

    public ByteOrder order() {
        return this.buf.order();
    }

    public void position(int pos) {
        this.buf.position(pos);
    }

    public void order(ByteOrder v) {
        this.buf.order(v);
    }

    public void flip() {
        this.buf.flip();
    }

    @Override
    public byte getByte(FieldBase field) {
        return this.buf.getByteBuffer().get();
    }

    @Override
    public short getShort(FieldBase field) {
        return this.buf.getByteBuffer().getShort();
    }

    @Override
    public int getInt(FieldBase field) {
        return this.buf.getByteBuffer().getInt();
    }

    @Override
    public long getLong(FieldBase field) {
        return this.buf.getByteBuffer().getLong();
    }

    @Override
    public float getFloat(FieldBase field) {
        return this.buf.getByteBuffer().getFloat();
    }

    @Override
    public double getDouble(FieldBase field) {
        return this.buf.getByteBuffer().getDouble();
    }

    @Override
    public byte[] getBytes(FieldBase field, int length) {
        if (this.buf.remaining() < length) {
            throw new IllegalArgumentException("Wanted " + length + " bytes, but I only had " + this.buf.remaining());
        }
        byte[] bbuf = new byte[length];
        this.buf.getByteBuffer().get(bbuf);
        return bbuf;
    }

    @Override
    public String getString(FieldBase field) {
        int length = this.getInt(null);
        byte[] stringArray = new byte[length - 1];
        this.buf.get(stringArray);
        this.getByte(null);
        return Utf8.toString(stringArray);
    }

    public int getInt1_4Bytes(FieldBase field) {
        return this.buf.getInt1_4Bytes();
    }

    public int getInt1_2_4Bytes(FieldBase field) {
        return this.buf.getInt1_2_4Bytes();
    }

    public long getInt2_4_8Bytes(FieldBase field) {
        return this.buf.getInt2_4_8Bytes();
    }

    public int remaining() {
        return this.buf.remaining();
    }

    public static byte[] createUTF8CharArray(String input) {
        if (input == null || input.length() < 1) {
            return new byte[0];
        }
        return Utf8.toBytes(input);
    }
}

