/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.compress;

import java.nio.ByteBuffer;

public class IntegerCompressor {
    public static Mode compressionMode(int min, int max) {
        if (min >= 0 && max < 0x40000000) {
            return Mode.COMPRESSED_POSITIVE;
        }
        if (min > -536870912 && max < 0x20000000) {
            return Mode.COMPRESSED;
        }
        return Mode.NONE;
    }

    public static void putCompressedNumber(int n, ByteBuffer buf) {
        int negative;
        int n2 = negative = n < 0 ? 128 : 0;
        if (negative != 0 && (n = -n) == -n) {
            --n;
        }
        if (n < 32) {
            byte b = (byte)(n | negative);
            buf.put(b);
        } else if (n < 8192) {
            n = n | 0x4000 | negative << 8;
            buf.putShort((short)n);
        } else if (n < 0x20000000) {
            n = n | 0x60000000 | negative << 24;
            buf.putInt(n);
        } else {
            throw new IllegalArgumentException("Number '" + (negative != 0 ? -n : n) + "' too big, must extend encoding");
        }
    }

    public static void putCompressedPositiveNumber(int n, ByteBuffer buf) {
        if (n < 0) {
            throw new IllegalArgumentException("Number '" + n + "' must be positive");
        }
        if (n < 64) {
            buf.put((byte)n);
        } else if (n < 16384) {
            buf.putShort((short)(n |= 0x8000));
        } else if (n < 0x40000000) {
            buf.putInt(n |= 0xC0000000);
        } else {
            throw new IllegalArgumentException("Number '" + n + "' too big, must extend encoding");
        }
    }

    public static enum Mode {
        NONE,
        COMPRESSED,
        COMPRESSED_POSITIVE;

    }
}

