/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.utils;

import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BytesQuantity {
    private final long bytes;
    private static final Pattern PATTERN = Pattern.compile("^(?<digits>\\d+)\\s*(?<unit>[a-zA-Z]*)$");

    private BytesQuantity(long bytes) {
        this.bytes = bytes;
    }

    public long toBytes() {
        return this.bytes;
    }

    public static BytesQuantity ofBytes(long bytes) {
        return new BytesQuantity(bytes);
    }

    public static BytesQuantity ofKB(long kb) {
        return BytesQuantity.of(kb, Unit.KB);
    }

    public static BytesQuantity ofMB(long mb) {
        return BytesQuantity.of(mb, Unit.MB);
    }

    public static BytesQuantity ofGB(long gb) {
        return BytesQuantity.of(gb, Unit.GB);
    }

    public static BytesQuantity ofTB(long tb) {
        return BytesQuantity.of(tb, Unit.TB);
    }

    public static BytesQuantity of(long value, Unit unit) {
        return new BytesQuantity(value * unit.binarySize());
    }

    public static BytesQuantity fromString(String value) {
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Bytes quantity '%s' does not match pattern '%s'".formatted(value, PATTERN.pattern()));
        }
        long digits = Long.parseLong(matcher.group("digits"));
        Unit unit = Unit.fromString(matcher.group("unit"));
        return BytesQuantity.of(digits, unit);
    }

    public String asPrettyString() {
        int unit;
        if (this.bytes == 0L) {
            return "0 bytes";
        }
        if (this.bytes == 1L) {
            return "1 byte";
        }
        long remaining = this.bytes;
        for (unit = 0; remaining % 1024L == 0L && unit < Unit.values().length - 1; ++unit) {
            remaining /= 1024L;
        }
        return String.format(Locale.ENGLISH, "%d %s", remaining, Unit.values()[unit].toUnitString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytesQuantity that = (BytesQuantity)o;
        return this.bytes == that.bytes;
    }

    public int hashCode() {
        return Objects.hashCode(this.bytes);
    }

    public String toString() {
        return this.asPrettyString();
    }

    public static enum Unit {
        BYTES,
        KB,
        MB,
        GB,
        TB;


        public long binarySize() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case BYTES -> 1L;
                case KB -> 1024L;
                case MB -> 0x100000L;
                case GB -> 0x40000000L;
                case TB -> 0x10000000000L;
            };
        }

        public String toUnitString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case BYTES -> "bytes";
                case KB -> "kB";
                case MB -> "MB";
                case GB -> "GB";
                case TB -> "TB";
            };
        }

        static Unit fromString(String s) {
            return switch (s) {
                case "", "B", "bytes", "byte" -> BYTES;
                case "kB", "k", "K", "KB" -> KB;
                case "MB", "m", "M" -> MB;
                case "GB", "g", "G" -> GB;
                case "TB", "t", "T" -> TB;
                default -> throw new IllegalArgumentException("Invalid unit: " + s);
            };
        }
    }
}

