/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.net;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Url {
    private static final Pattern pattern = Pattern.compile("^(([^:/?#]+):)?(//(([^:@/?#]+)(:([^@/?#]+))?@)?((\\[([^]]+)]|[^:/?#]+)(:([^/?#]+))?))?([^?#]+)?(\\?([^#]*))?(#(.*))?");
    private final String image;
    private final int schemeBegin;
    private final int schemeEnd;
    private final int userInfoBegin;
    private final int userInfoEnd;
    private final int passwordBegin;
    private final int passwordEnd;
    private final int hostBegin;
    private final int hostEnd;
    private final int portBegin;
    private final int portEnd;
    private final int pathBegin;
    private final int pathEnd;
    private final int queryBegin;
    private final int queryEnd;
    private final int fragmentBegin;
    private final int fragmentEnd;

    public Url(String scheme, String user, String password, String host, Integer port, String path, String query, String fragment) {
        StringBuilder image = new StringBuilder();
        this.schemeBegin = image.length();
        if (scheme != null) {
            image.append(scheme);
            this.schemeEnd = image.length();
            image.append(':');
        } else {
            this.schemeEnd = this.schemeBegin;
        }
        if (host != null) {
            image.append("//");
        }
        this.userInfoBegin = image.length();
        if (user != null) {
            image.append(user);
            this.userInfoEnd = image.length();
        } else {
            this.userInfoEnd = this.userInfoBegin;
        }
        if (password != null) {
            image.append(':');
            this.passwordBegin = image.length();
            image.append(password);
            this.passwordEnd = image.length();
        } else {
            this.passwordEnd = this.passwordBegin = image.length();
        }
        if (user != null || password != null) {
            image.append('@');
        }
        if (host != null) {
            boolean esc;
            boolean bl = esc = host.indexOf(58) >= 0;
            if (esc) {
                image.append('[');
            }
            this.hostBegin = image.length();
            image.append(host);
            this.hostEnd = image.length();
            if (esc) {
                image.append(']');
            }
        } else {
            this.hostEnd = this.hostBegin = image.length();
        }
        if (port != null) {
            image.append(':');
            this.portBegin = image.length();
            image.append(port);
            this.portEnd = image.length();
        } else {
            this.portEnd = this.portBegin = image.length();
        }
        this.pathBegin = image.length();
        if (path != null) {
            image.append(path);
            this.pathEnd = image.length();
        } else {
            this.pathEnd = this.pathBegin;
        }
        if (query != null) {
            image.append('?');
            this.queryBegin = image.length();
            image.append(query);
            this.queryEnd = image.length();
        } else {
            this.queryEnd = this.queryBegin = image.length();
        }
        if (fragment != null) {
            image.append("#");
            this.fragmentBegin = image.length();
            image.append(fragment);
            this.fragmentEnd = image.length();
        } else {
            this.fragmentEnd = this.fragmentBegin = image.length();
        }
        this.image = image.toString();
    }

    public static Url fromString(String image) {
        Matcher matcher = pattern.matcher(image);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Malformed URL.");
        }
        String host = matcher.group(10);
        if (host == null) {
            host = matcher.group(9);
        }
        if (host == null) {
            host = matcher.group(8);
        }
        String port = matcher.group(12);
        return new Url(matcher.group(2), matcher.group(5), matcher.group(7), host, port != null ? Integer.valueOf(port) : null, matcher.group(13), matcher.group(15), matcher.group(17));
    }

    public int getSchemeBegin() {
        return this.schemeBegin;
    }

    public int getSchemeEnd() {
        return this.schemeEnd;
    }

    public int getUserInfoBegin() {
        return this.userInfoBegin;
    }

    public int getUserInfoEnd() {
        return this.userInfoEnd;
    }

    public int getPasswordBegin() {
        return this.passwordBegin;
    }

    public int getPasswordEnd() {
        return this.passwordEnd;
    }

    public int getHostBegin() {
        return this.hostBegin;
    }

    public int getHostEnd() {
        return this.hostEnd;
    }

    public int getPortBegin() {
        return this.portBegin;
    }

    public int getPortEnd() {
        return this.portEnd;
    }

    public int getPathBegin() {
        return this.pathBegin;
    }

    public int getPathEnd() {
        return this.pathEnd;
    }

    public int getQueryBegin() {
        return this.queryBegin;
    }

    public int getQueryEnd() {
        return this.queryEnd;
    }

    public int getFragmentBegin() {
        return this.fragmentBegin;
    }

    public int getFragmentEnd() {
        return this.fragmentEnd;
    }

    public String getScheme() {
        return this.schemeBegin < this.schemeEnd ? this.image.substring(this.schemeBegin, this.schemeEnd) : null;
    }

    public String getUserInfo() {
        return this.userInfoBegin < this.userInfoEnd ? this.image.substring(this.userInfoBegin, this.userInfoEnd) : null;
    }

    public String getPassword() {
        return this.passwordBegin < this.passwordEnd ? this.image.substring(this.passwordBegin, this.passwordEnd) : null;
    }

    public String getHost() {
        return this.hostBegin < this.hostEnd ? this.image.substring(this.hostBegin, this.hostEnd) : null;
    }

    public Integer getPort() {
        String str = this.getPortString();
        return str != null ? Integer.valueOf(str) : null;
    }

    public String getPortString() {
        return this.portBegin < this.portEnd ? this.image.substring(this.portBegin, this.portEnd) : null;
    }

    public String getPath() {
        return this.pathBegin < this.pathEnd ? this.image.substring(this.pathBegin, this.pathEnd) : null;
    }

    public String getQuery() {
        return this.queryBegin < this.queryEnd ? this.image.substring(this.queryBegin, this.queryEnd) : null;
    }

    public String getFragment() {
        return this.fragmentBegin < this.fragmentEnd ? this.image.substring(this.fragmentBegin, this.fragmentEnd) : null;
    }

    public int hashCode() {
        return this.image.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Url && this.image.equals(((Url)obj).image);
    }

    public String toString() {
        return this.image;
    }
}

