/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.binaryprefix;

public enum BinaryPrefix {
    unit(0),
    kilo(1, 'K'),
    mega(2, 'M'),
    giga(3, 'G'),
    tera(4, 'T'),
    peta(5, 'P'),
    exa(6, 'E'),
    zetta(7, 'Z'),
    yotta(8, 'Y');

    private final int k;
    public final char symbol;

    private BinaryPrefix(int k, char symbol) {
        this.k = k;
        this.symbol = symbol;
    }

    private BinaryPrefix(int k) {
        this(k, '\u0000');
    }

    public double convertFrom(double value, BinaryPrefix binaryPrefix) {
        return value * Math.pow(2.0, 10 * (binaryPrefix.k - this.k));
    }

    public static BinaryPrefix fromSymbol(char c) {
        for (BinaryPrefix binaryPrefix : BinaryPrefix.values()) {
            if (binaryPrefix.symbol != c) continue;
            return binaryPrefix;
        }
        throw new RuntimeException("No such binary prefix: " + c);
    }
}

