/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.TreeSet;

public class CrossLinker {
    private final boolean verbose;
    int numDirsSynced = 0;
    int numFilesLinked = 0;
    int numFilesCopied = 0;
    int numNonRegularFiles = 0;
    int numConflicts = 0;
    int numAlreadyPresent = 0;
    int numCopyFailures = 0;

    public CrossLinker() {
        this(false);
    }

    public CrossLinker(boolean verbose) {
        this.verbose = verbose;
    }

    public void crossLink(String srcDir, String dstDir) {
        try {
            Path src = Path.of(srcDir, new String[0]);
            Path dst = Path.of(dstDir, new String[0]);
            this.crossLink(src, dst);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    Set<Path> entries(Path dir) throws IOException {
        TreeSet<Path> result = new TreeSet<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path p : stream) {
                result.add(p.getFileName());
            }
        }
        return result;
    }

    void maybeSync(Path src, Path dst) throws IOException {
        if (Files.isDirectory(src, new LinkOption[0])) {
            if (Files.isDirectory(dst, new LinkOption[0])) {
                this.crossLink(src, dst);
            } else {
                System.err.println("cannot sync directory " + String.valueOf(src) + " <-> non-directory " + String.valueOf(dst));
                ++this.numConflicts;
            }
        } else if (Files.isDirectory(dst, new LinkOption[0])) {
            System.err.println("cannot sync non-directory " + String.valueOf(src) + " <-> directory " + String.valueOf(dst));
            ++this.numConflicts;
        }
        ++this.numAlreadyPresent;
    }

    void linkOrCopy(Path src, Path dst) {
        if (!Files.isRegularFile(src, LinkOption.NOFOLLOW_LINKS)) {
            ++this.numNonRegularFiles;
            return;
        }
        try {
            Path ok = Files.createLink(dst, src);
            ++this.numFilesLinked;
            if (this.verbose) {
                System.out.println("link " + String.valueOf(src) + " -> " + String.valueOf(ok));
            }
            return;
        }
        catch (IOException ok) {
            try {
                Path tmp = Files.createTempFile(dst.getParent(), "tmp-", ".tmp", new FileAttribute[0]);
                Files.delete(tmp);
                Files.copy(src, tmp, new CopyOption[0]);
                Path ok2 = Files.move(tmp, dst, new CopyOption[0]);
                ++this.numFilesCopied;
                if (this.verbose) {
                    System.out.println("copy " + String.valueOf(src) + " -> " + String.valueOf(dst));
                }
            }
            catch (IOException e) {
                System.err.println("[IGNORED " + String.valueOf(e) + "] Could not copy " + String.valueOf(src) + " -> " + String.valueOf(dst));
                ++this.numCopyFailures;
            }
            return;
        }
    }

    void crossLink(Path src, Path dst) throws IOException {
        Path bSub;
        Path aSub;
        ++this.numDirsSynced;
        Path a = Files.createDirectories(src, new FileAttribute[0]);
        Path b = Files.createDirectories(dst, new FileAttribute[0]);
        Set<Path> aSet = this.entries(a);
        Set<Path> bSet = this.entries(b);
        for (Path entry : aSet) {
            aSub = a.resolve(entry);
            bSub = b.resolve(entry);
            if (bSet.contains(entry)) {
                this.maybeSync(aSub, bSub);
                continue;
            }
            if (Files.isDirectory(aSub, new LinkOption[0])) {
                this.crossLink(aSub, bSub);
                continue;
            }
            this.linkOrCopy(aSub, bSub);
        }
        for (Path entry : bSet) {
            if (aSet.contains(entry)) continue;
            aSub = a.resolve(entry);
            bSub = b.resolve(entry);
            if (Files.isDirectory(bSub, new LinkOption[0])) {
                this.crossLink(aSub, bSub);
                continue;
            }
            this.linkOrCopy(bSub, aSub);
        }
    }

    public void dumpAndResetStats() {
        System.err.println("Synced " + this.numDirsSynced + " directories:");
        if (this.numFilesLinked > 0) {
            System.err.println("  -  files linked: " + this.numFilesLinked);
        }
        if (this.numFilesCopied > 0) {
            System.err.println("  -  files copied: " + this.numFilesCopied);
        }
        if (this.numNonRegularFiles > 0) {
            System.err.println("  -  non-regular files skipped: " + this.numNonRegularFiles);
        }
        if (this.numConflicts > 0) {
            System.err.println("  -  dir/file conflicts skipped: " + this.numConflicts);
        }
        if (this.numAlreadyPresent > 0) {
            System.err.println("  -  files already present skipped: " + this.numAlreadyPresent);
        }
        if (this.numCopyFailures > 0) {
            System.err.println("  -  failures to link or copy: " + this.numCopyFailures);
        }
        this.numDirsSynced = 0;
        this.numFilesLinked = 0;
        this.numFilesCopied = 0;
        this.numNonRegularFiles = 0;
        this.numConflicts = 0;
        this.numAlreadyPresent = 0;
        this.numCopyFailures = 0;
    }
}

