/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.protect;

public abstract class Validator {
    public static void ensureNotNull(String argumentDescription, Object argument) {
        if (argument == null) {
            throw new NullPointerException(argumentDescription + " can not be null");
        }
    }

    public static void ensureNonEmpty(String argumentDescription, String argument) {
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(argumentDescription + " can not be empty");
        }
    }

    public static void ensureNotInitialized(String fieldDescription, Object fieldOwner, Object fieldValue) {
        if (fieldValue != null) {
            throw new IllegalStateException(fieldDescription + " of " + String.valueOf(fieldOwner) + " cannot be changed, it is already set to " + String.valueOf(fieldValue));
        }
    }

    public static void ensureInRange(String argumentDescription, int from, int to, int argument) {
        if (argument < from || argument > to) {
            throw new IllegalArgumentException(argumentDescription + " is " + argument + " but must be between " + from + " and " + to);
        }
    }

    public static void ensureSmaller(String smallDescription, int small, String largeDescription, int large) {
        if (small >= large) {
            throw new IllegalArgumentException(smallDescription + " is " + small + " but should be less than " + largeDescription + " " + large);
        }
    }

    public static void ensureSmaller(String smallDescription, Comparable small, String largeDescription, Comparable large) {
        if (small.compareTo(large) >= 0) {
            throw new IllegalArgumentException(smallDescription + " is " + String.valueOf(small) + " but should be less than " + largeDescription + " " + String.valueOf(large));
        }
    }

    public static void ensure(String description, boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException(description);
        }
    }

    public static void ensure(boolean condition, Object ... description) {
        if (!condition) {
            StringBuilder msg = new StringBuilder();
            for (Object part : description) {
                msg.append(part.toString());
            }
            throw new IllegalArgumentException(msg.toString());
        }
    }

    public static void ensureInstanceOf(String description, Object item, Class<?> type) {
        if (!type.isAssignableFrom(item.getClass())) {
            throw new IllegalArgumentException(description + " " + String.valueOf(item) + " should be an instance of " + String.valueOf(type) + " but is " + String.valueOf(item.getClass()));
        }
    }

    public static void ensureNotInstanceOf(String description, Object item, Class<?> type) {
        if (type.isAssignableFrom(item.getClass())) {
            throw new IllegalArgumentException(description + " " + String.valueOf(item) + " should NOT be an instance of " + String.valueOf(type) + " but is " + String.valueOf(item.getClass()));
        }
    }
}

