/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.clientmetrics.ClientMetrics;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.feedapi.MessagePropertyProcessor;
import com.yahoo.feedapi.SessionFactory;
import com.yahoo.feedapi.SharedSender;
import java.util.Map;
import java.util.TreeMap;

public class FeedContext {
    private final SessionFactory factory;
    private final MessagePropertyProcessor propertyProcessor;
    private final DocumentTypeManager docTypeManager;
    private final ClientMetrics metrics;
    private Map<String, SharedSender> senders = new TreeMap<String, SharedSender>();
    public static final Object sync = new Object();
    public static FeedContext instance = null;

    public FeedContext(MessagePropertyProcessor propertyProcessor, SessionFactory factory, DocumentTypeManager manager) {
        this.propertyProcessor = propertyProcessor;
        this.factory = factory;
        this.docTypeManager = manager;
        this.metrics = new ClientMetrics();
    }

    private void shutdownSenders() {
        for (SharedSender s : this.senders.values()) {
            s.shutdown();
        }
    }

    public synchronized SharedSender getSharedSender(String route) {
        SharedSender sender;
        if (this.propertyProcessor.configChanged()) {
            TreeMap<String, SharedSender> newSenders = new TreeMap<String, SharedSender>();
            for (Map.Entry<String, SharedSender> sender2 : this.senders.entrySet()) {
                newSenders.put(sender2.getKey(), new SharedSender(sender2.getKey(), this.factory, sender2.getValue()));
            }
            this.shutdownSenders();
            this.senders = newSenders;
            this.propertyProcessor.setConfigChanged(false);
        }
        if (route == null) {
            route = this.propertyProcessor.getFeederOptions().getRoute();
        }
        if ((sender = this.senders.get(route)) == null) {
            sender = new SharedSender(route, this.factory, null);
            this.senders.put(route, sender);
            this.metrics.addRouteMetricSet(sender.getMetrics());
        }
        return sender;
    }

    public MessagePropertyProcessor getPropertyProcessor() {
        return this.propertyProcessor;
    }

    public DocumentTypeManager getDocumentTypeManager() {
        return this.docTypeManager;
    }
}

