// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespaclient.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of feeder
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class FeederConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "7723c201b88980519f6cb6cf1ee7c160";
  public final static String CONFIG_DEF_NAME = "feeder";
  public final static String CONFIG_DEF_NAMESPACE = "vespaclient.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespaclient.config",
    "abortondocumenterror bool default=true",
    "abortonsenderror bool default=true",
    "idprefix string default=\"\"",
    "maxpendingdocs int default=0",
    "maxpendingbytes int default=0",
    "maxbusythreads int default=150",
    "maxfeedrate double default=0.0",
    "retryenabled bool default=true",
    "retrydelay double default=1",
    "timeout double default=180",
    "route string default=\"default\"",
    "tracelevel int default=0",
    "mbusport int default=-1",
    "docprocchain string default=\"\"",
    "createifnonexistent bool default=false"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean abortondocumenterror = null;
    private Boolean abortonsenderror = null;
    private String idprefix = null;
    private Integer maxpendingdocs = null;
    private Integer maxpendingbytes = null;
    private Integer maxbusythreads = null;
    private Double maxfeedrate = null;
    private Boolean retryenabled = null;
    private Double retrydelay = null;
    private Double timeout = null;
    private String route = null;
    private Integer tracelevel = null;
    private Integer mbusport = null;
    private String docprocchain = null;
    private Boolean createifnonexistent = null;

    public Builder() { }

    public Builder(FeederConfig config) {
      abortondocumenterror(config.abortondocumenterror());
      abortonsenderror(config.abortonsenderror());
      idprefix(config.idprefix());
      maxpendingdocs(config.maxpendingdocs());
      maxpendingbytes(config.maxpendingbytes());
      maxbusythreads(config.maxbusythreads());
      maxfeedrate(config.maxfeedrate());
      retryenabled(config.retryenabled());
      retrydelay(config.retrydelay());
      timeout(config.timeout());
      route(config.route());
      tracelevel(config.tracelevel());
      mbusport(config.mbusport());
      docprocchain(config.docprocchain());
      createifnonexistent(config.createifnonexistent());
    }

    private Builder override(Builder __superior) {
      if (__superior.abortondocumenterror != null)
        abortondocumenterror(__superior.abortondocumenterror);
      if (__superior.abortonsenderror != null)
        abortonsenderror(__superior.abortonsenderror);
      if (__superior.idprefix != null)
        idprefix(__superior.idprefix);
      if (__superior.maxpendingdocs != null)
        maxpendingdocs(__superior.maxpendingdocs);
      if (__superior.maxpendingbytes != null)
        maxpendingbytes(__superior.maxpendingbytes);
      if (__superior.maxbusythreads != null)
        maxbusythreads(__superior.maxbusythreads);
      if (__superior.maxfeedrate != null)
        maxfeedrate(__superior.maxfeedrate);
      if (__superior.retryenabled != null)
        retryenabled(__superior.retryenabled);
      if (__superior.retrydelay != null)
        retrydelay(__superior.retrydelay);
      if (__superior.timeout != null)
        timeout(__superior.timeout);
      if (__superior.route != null)
        route(__superior.route);
      if (__superior.tracelevel != null)
        tracelevel(__superior.tracelevel);
      if (__superior.mbusport != null)
        mbusport(__superior.mbusport);
      if (__superior.docprocchain != null)
        docprocchain(__superior.docprocchain);
      if (__superior.createifnonexistent != null)
        createifnonexistent(__superior.createifnonexistent);
      return this;
    }

    public Builder abortondocumenterror(boolean __value) {
      abortondocumenterror = __value;
      return this;
    }

    private Builder abortondocumenterror(String __value) {
      return abortondocumenterror(Boolean.valueOf(__value));
    }

    public Builder abortonsenderror(boolean __value) {
      abortonsenderror = __value;
      return this;
    }

    private Builder abortonsenderror(String __value) {
      return abortonsenderror(Boolean.valueOf(__value));
    }

    public Builder idprefix(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      idprefix = __value;
      return this;
    }


    public Builder maxpendingdocs(int __value) {
      maxpendingdocs = __value;
      return this;
    }

    private Builder maxpendingdocs(String __value) {
      return maxpendingdocs(Integer.valueOf(__value));
    }

    public Builder maxpendingbytes(int __value) {
      maxpendingbytes = __value;
      return this;
    }

    private Builder maxpendingbytes(String __value) {
      return maxpendingbytes(Integer.valueOf(__value));
    }

    public Builder maxbusythreads(int __value) {
      maxbusythreads = __value;
      return this;
    }

    private Builder maxbusythreads(String __value) {
      return maxbusythreads(Integer.valueOf(__value));
    }

    public Builder maxfeedrate(double __value) {
      maxfeedrate = __value;
      return this;
    }

    private Builder maxfeedrate(String __value) {
      return maxfeedrate(Double.valueOf(__value));
    }

    public Builder retryenabled(boolean __value) {
      retryenabled = __value;
      return this;
    }

    private Builder retryenabled(String __value) {
      return retryenabled(Boolean.valueOf(__value));
    }

    public Builder retrydelay(double __value) {
      retrydelay = __value;
      return this;
    }

    private Builder retrydelay(String __value) {
      return retrydelay(Double.valueOf(__value));
    }

    public Builder timeout(double __value) {
      timeout = __value;
      return this;
    }

    private Builder timeout(String __value) {
      return timeout(Double.valueOf(__value));
    }

    public Builder route(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      route = __value;
      return this;
    }


    public Builder tracelevel(int __value) {
      tracelevel = __value;
      return this;
    }

    private Builder tracelevel(String __value) {
      return tracelevel(Integer.valueOf(__value));
    }

    public Builder mbusport(int __value) {
      mbusport = __value;
      return this;
    }

    private Builder mbusport(String __value) {
      return mbusport(Integer.valueOf(__value));
    }

    public Builder docprocchain(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      docprocchain = __value;
      return this;
    }


    public Builder createifnonexistent(boolean __value) {
      createifnonexistent = __value;
      return this;
    }

    private Builder createifnonexistent(String __value) {
      return createifnonexistent(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public FeederConfig build() {
      return new FeederConfig(this);
    }

  }

  // Whether or not to abort if there are document-related errors.
  // Value 'false' will skip bad documents, but still abort on other errors.
  private final BooleanNode abortondocumenterror;
  // Whether or not to abort if there are errors sending messages to Vespa
  private final BooleanNode abortonsenderror;
  // Prefix each document id with this string.
  private final StringNode idprefix;
  // Max number of pending operations.
  private final IntegerNode maxpendingdocs;
  // Max number of bytes in pending operations.
  private final IntegerNode maxpendingbytes;
  // Max number of busy threads
  private final IntegerNode maxbusythreads;
  // Max number of operations to perform per second (0 == no max)
  private final DoubleNode maxfeedrate;
  // Whether or not retrying is enabled.
  private final BooleanNode retryenabled;
  // Delay between retries.
  private final DoubleNode retrydelay;
  // Timeout for messagebus operations.
  private final DoubleNode timeout;
  // Route to feed documents on
  private final StringNode route;
  // Trace level for messages
  private final IntegerNode tracelevel;
  // Messagebus port to start source session on
  private final IntegerNode mbusport;
  // Default docproc chain to run
  private final StringNode docprocchain;
  // Whether or not to set create-if-non-existent flag on all document updates handled by a feeder.
  private final BooleanNode createifnonexistent;

  public FeederConfig(Builder builder) {
    this(builder, true);
  }

  private FeederConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "feeder must be initialized: " + builder.__uninitialized);

    abortondocumenterror = (builder.abortondocumenterror == null) ?
        new BooleanNode(true) : new BooleanNode(builder.abortondocumenterror);
    abortonsenderror = (builder.abortonsenderror == null) ?
        new BooleanNode(true) : new BooleanNode(builder.abortonsenderror);
    idprefix = (builder.idprefix == null) ?
        new StringNode("") : new StringNode(builder.idprefix);
    maxpendingdocs = (builder.maxpendingdocs == null) ?
        new IntegerNode(0) : new IntegerNode(builder.maxpendingdocs);
    maxpendingbytes = (builder.maxpendingbytes == null) ?
        new IntegerNode(0) : new IntegerNode(builder.maxpendingbytes);
    maxbusythreads = (builder.maxbusythreads == null) ?
        new IntegerNode(150) : new IntegerNode(builder.maxbusythreads);
    maxfeedrate = (builder.maxfeedrate == null) ?
        new DoubleNode(0.0D) : new DoubleNode(builder.maxfeedrate);
    retryenabled = (builder.retryenabled == null) ?
        new BooleanNode(true) : new BooleanNode(builder.retryenabled);
    retrydelay = (builder.retrydelay == null) ?
        new DoubleNode(1D) : new DoubleNode(builder.retrydelay);
    timeout = (builder.timeout == null) ?
        new DoubleNode(180D) : new DoubleNode(builder.timeout);
    route = (builder.route == null) ?
        new StringNode("default") : new StringNode(builder.route);
    tracelevel = (builder.tracelevel == null) ?
        new IntegerNode(0) : new IntegerNode(builder.tracelevel);
    mbusport = (builder.mbusport == null) ?
        new IntegerNode(-1) : new IntegerNode(builder.mbusport);
    docprocchain = (builder.docprocchain == null) ?
        new StringNode("") : new StringNode(builder.docprocchain);
    createifnonexistent = (builder.createifnonexistent == null) ?
        new BooleanNode(false) : new BooleanNode(builder.createifnonexistent);
  }

  /**
   * @return feeder.abortondocumenterror
   */
  public boolean abortondocumenterror() {
    return abortondocumenterror.value();
  }

  /**
   * @return feeder.abortonsenderror
   */
  public boolean abortonsenderror() {
    return abortonsenderror.value();
  }

  /**
   * @return feeder.idprefix
   */
  public String idprefix() {
    return idprefix.value();
  }

  /**
   * @return feeder.maxpendingdocs
   */
  public int maxpendingdocs() {
    return maxpendingdocs.value();
  }

  /**
   * @return feeder.maxpendingbytes
   */
  public int maxpendingbytes() {
    return maxpendingbytes.value();
  }

  /**
   * @return feeder.maxbusythreads
   */
  public int maxbusythreads() {
    return maxbusythreads.value();
  }

  /**
   * @return feeder.maxfeedrate
   */
  public double maxfeedrate() {
    return maxfeedrate.value();
  }

  /**
   * @return feeder.retryenabled
   */
  public boolean retryenabled() {
    return retryenabled.value();
  }

  /**
   * @return feeder.retrydelay
   */
  public double retrydelay() {
    return retrydelay.value();
  }

  /**
   * @return feeder.timeout
   */
  public double timeout() {
    return timeout.value();
  }

  /**
   * @return feeder.route
   */
  public String route() {
    return route.value();
  }

  /**
   * @return feeder.tracelevel
   */
  public int tracelevel() {
    return tracelevel.value();
  }

  /**
   * @return feeder.mbusport
   */
  public int mbusport() {
    return mbusport.value();
  }

  /**
   * @return feeder.docprocchain
   */
  public String docprocchain() {
    return docprocchain.value();
  }

  /**
   * @return feeder.createifnonexistent
   */
  public boolean createifnonexistent() {
    return createifnonexistent.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(FeederConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("feeder");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
