/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.document.DocumentTypeManager;
import com.yahoo.feedapi.VespaFeedSender;
import com.yahoo.vespaxmlparser.FeedOperation;
import com.yahoo.vespaxmlparser.FeedReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public abstract class Feeder {
    protected final InputStream stream;
    protected final DocumentTypeManager docMan;
    protected List<String> errors = new LinkedList<String>();
    private boolean doAbort = true;
    private boolean createIfNonExistent = false;
    private final VespaFeedSender sender;
    private static final int MAX_ERRORS = 10;

    protected Feeder(DocumentTypeManager docMan, VespaFeedSender sender, InputStream stream) {
        this.docMan = docMan;
        this.sender = sender;
        this.stream = stream;
    }

    public void setAbortOnDocumentError(boolean doAbort) {
        this.doAbort = doAbort;
    }

    public void setCreateIfNonExistent(boolean value) {
        this.createIfNonExistent = value;
    }

    private void addException(Exception e) {
        Object message;
        if (e.getMessage() != null) {
            message = e.getMessage().replaceAll("\"", "'");
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            message = "(no message) " + String.valueOf(sw);
        }
        this.addError("ERROR: " + (String)message);
    }

    private void addError(String error) {
        if (this.errors.size() < 10) {
            this.errors.add(error);
        } else if (this.errors.size() == 10) {
            this.errors.add("Reached maximum limit of errors (10). Not collecting any more.");
        }
    }

    protected abstract FeedReader createReader() throws Exception;

    public List<String> parse() {
        FeedReader reader;
        try {
            reader = this.createReader();
        }
        catch (Exception e) {
            this.addError("ERROR: " + e.getClass().toString() + ": " + e.getMessage().replaceAll("\"", "'"));
            return this.errors;
        }
        while (!this.sender.isAborted()) {
            try {
                FeedOperation op = reader.read();
                if (this.createIfNonExistent) {
                    if (op.getDocumentUpdate() != null) {
                        op.getDocumentUpdate().setCreateIfNonExistent(true);
                    }
                    if (op.getDocumentPut() != null) {
                        op.getDocumentPut().setCreateIfNonExistent(true);
                    }
                }
                if (op.getType() == FeedOperation.Type.INVALID) break;
                this.sender.sendOperation(op);
            }
            catch (NullPointerException | XMLStreamException e) {
                this.addException(e);
                break;
            }
            catch (Exception e) {
                this.addException(e);
                if (!this.doAbort) continue;
                break;
            }
        }
        return this.errors;
    }
}

