/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedhandler;

import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.feedapi.SimpleFeedAccess;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class ThreadedFeedAccess
implements SimpleFeedAccess {
    private final SimpleFeedAccess simpleFeedAccess;
    private final ExecutorService executorService;
    private final Executor executor;

    ThreadedFeedAccess(int numThreads, SimpleFeedAccess simpleFeedAccess) {
        this.simpleFeedAccess = simpleFeedAccess;
        if (numThreads <= 0) {
            numThreads = Runtime.getRuntime().availableProcessors();
        }
        if (numThreads > 1) {
            this.executorService = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(false), ThreadFactoryFactory.getDaemonThreadFactory((String)"feeder"), new ThreadPoolExecutor.CallerRunsPolicy());
            this.executor = this.executorService;
        } else {
            this.executorService = null;
            this.executor = new Executor(){

                @Override
                public void execute(Runnable command) {
                    command.run();
                }
            };
        }
    }

    @Override
    public void put(DocumentPut doc) {
        this.executor.execute(() -> this.simpleFeedAccess.put(doc));
    }

    @Override
    public void remove(DocumentRemove remove) {
        this.executor.execute(() -> this.simpleFeedAccess.remove(remove));
    }

    @Override
    public void update(DocumentUpdate update) {
        this.executor.execute(() -> this.simpleFeedAccess.update(update));
    }

    @Override
    public boolean isAborted() {
        return this.simpleFeedAccess.isAborted();
    }

    @Override
    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

