/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.messagebus.DynamicThrottlePolicy;
import com.yahoo.messagebus.RateThrottlingPolicy;
import com.yahoo.messagebus.SourceSessionParams;
import com.yahoo.messagebus.StaticThrottlePolicy;
import com.yahoo.messagebus.ThrottlePolicy;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;
import com.yahoo.vespaclient.config.FeederConfig;

public class FeederOptions {
    private boolean abortOnDocumentError = true;
    private boolean abortOnSendError = true;
    private boolean retryEnabled = true;
    private double timeout = 60.0;
    private int maxPendingDocs = 0;
    private double maxFeedRate = 0.0;
    private String route = "default";
    private int traceLevel;
    private int mbusPort;
    private DocumentProtocol.Priority priority = DocumentProtocol.Priority.NORMAL_3;

    FeederOptions() {
    }

    FeederOptions(FeederConfig config) {
        this.setAbortOnDocumentError(config.abortondocumenterror());
        this.setAbortOnSendError(config.abortonsenderror());
        this.setMaxPendingDocs(config.maxpendingdocs());
        this.setRetryEnabled(config.retryenabled());
        this.setRoute(config.route());
        this.setTimeout(config.timeout());
        this.setTraceLevel(config.tracelevel());
        this.setMessageBusPort(config.mbusport());
        this.setMaxFeedRate(config.maxfeedrate());
    }

    void setMaxFeedRate(double feedRate) {
        this.maxFeedRate = feedRate;
    }

    boolean getRetryEnabled() {
        return this.retryEnabled;
    }

    private void setRetryEnabled(boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
    }

    public double getTimeout() {
        return this.timeout;
    }

    public void setTimeout(double timeout) {
        this.timeout = timeout;
    }

    private void setMaxPendingDocs(int maxPendingDocs) {
        this.maxPendingDocs = maxPendingDocs;
    }

    boolean abortOnDocumentError() {
        return this.abortOnDocumentError;
    }

    void setAbortOnDocumentError(boolean abortOnDocumentError) {
        this.abortOnDocumentError = abortOnDocumentError;
    }

    boolean abortOnSendError() {
        return this.abortOnSendError;
    }

    private void setAbortOnSendError(boolean abortOnSendError) {
        this.abortOnSendError = abortOnSendError;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public String getRoute() {
        return this.route;
    }

    public DocumentProtocol.Priority getPriority() {
        return this.priority;
    }

    int getTraceLevel() {
        return this.traceLevel;
    }

    public void setTraceLevel(int traceLevel) {
        this.traceLevel = traceLevel;
    }

    private void setMessageBusPort(int mbusPort) {
        this.mbusPort = mbusPort;
    }

    public void setPriority(DocumentProtocol.Priority priority) {
        this.priority = priority;
    }

    SourceSessionParams toSourceSessionParams() {
        SourceSessionParams params = new SourceSessionParams();
        Object policy = this.maxFeedRate > 0.0 ? new RateThrottlingPolicy(this.maxFeedRate) : (this.maxPendingDocs == 0 ? new DynamicThrottlePolicy() : new StaticThrottlePolicy());
        if (this.maxPendingDocs > 0) {
            policy.setMaxPendingCount(this.maxPendingDocs);
        }
        params.setThrottlePolicy((ThrottlePolicy)policy);
        params.setTimeout(this.getTimeout());
        return params;
    }

    RPCNetworkParams getNetworkParams() {
        try {
            RPCNetworkParams networkParams = new RPCNetworkParams();
            if (this.mbusPort != -1) {
                networkParams.setListenPort(this.mbusPort);
            }
            return networkParams;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return "FeederOptions{abortOnDocumentError=" + this.abortOnDocumentError + ", abortOnSendError=" + this.abortOnSendError + ", retryEnabled=" + this.retryEnabled + ", timeout=" + this.timeout + ", maxPendingDocs=" + this.maxPendingDocs + ", route='" + this.route + "', traceLevel=" + this.traceLevel + ", mbusPort=" + this.mbusPort + ", priority=" + this.priority.name() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FeederOptions)) {
            return false;
        }
        FeederOptions that = (FeederOptions)o;
        if (this.abortOnDocumentError != that.abortOnDocumentError) {
            return false;
        }
        if (this.abortOnSendError != that.abortOnSendError) {
            return false;
        }
        if (this.maxPendingDocs != that.maxPendingDocs) {
            return false;
        }
        if (this.maxFeedRate != that.maxFeedRate) {
            return false;
        }
        if (this.mbusPort != that.mbusPort) {
            return false;
        }
        if (this.retryEnabled != that.retryEnabled) {
            return false;
        }
        if (Double.compare(that.timeout, this.timeout) != 0) {
            return false;
        }
        if (this.traceLevel != that.traceLevel) {
            return false;
        }
        if (this.priority != that.priority) {
            return false;
        }
        return !(this.route != null ? !this.route.equals(that.route) : that.route != null);
    }

    public int hashCode() {
        int result = this.abortOnDocumentError ? 1 : 0;
        result = 31 * result + (this.abortOnSendError ? 1 : 0);
        result = 31 * result + (this.retryEnabled ? 1 : 0);
        long temp = this.timeout != 0.0 ? Double.doubleToLongBits(this.timeout) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.maxPendingDocs;
        result = 31 * result + (int)(this.maxFeedRate * 1000.0);
        result = 31 * result + (this.route != null ? this.route.hashCode() : 0);
        result = 31 * result + this.traceLevel;
        result = 31 * result + this.mbusPort;
        result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
        return result;
    }
}

