/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedhandler;

import com.yahoo.clientmetrics.RouteMetricSet;
import com.yahoo.feedapi.FeedContext;
import com.yahoo.feedapi.Feeder;
import com.yahoo.feedapi.JsonFeeder;
import com.yahoo.feedapi.MessagePropertyProcessor;
import com.yahoo.feedapi.SimpleFeedAccess;
import com.yahoo.feedapi.SingleSender;
import com.yahoo.feedapi.XMLFeeder;
import com.yahoo.feedhandler.FeedResponse;
import com.yahoo.feedhandler.InputStreamRequest;
import com.yahoo.feedhandler.ThreadedFeedAccess;
import com.yahoo.feedhandler.VespaFeedHandlerBase;
import com.yahoo.messagebus.Error;
import java.util.List;

public final class VespaFeedHandler
extends VespaFeedHandlerBase {
    public static final String JSON_INPUT = "jsonInput";

    private VespaFeedHandler(FeedContext context) {
        super(context);
    }

    public static VespaFeedHandler createFromContext(FeedContext context) {
        return new VespaFeedHandler(context);
    }

    public FeedResponse handle(InputStreamRequest request, RouteMetricSet.ProgressCallback callback, int numThreads) {
        MessagePropertyProcessor.PropertySetter properties = this.getPropertyProcessor().buildPropertySetter(request);
        String route = properties.getRoute().toString();
        FeedResponse response = new FeedResponse(new RouteMetricSet(route, callback));
        SingleSender sender = new SingleSender(response, this.getSharedSender(route));
        sender.addMessageProcessor(properties);
        ThreadedFeedAccess feedAccess = new ThreadedFeedAccess(numThreads, sender);
        Feeder feeder = this.createFeeder(feedAccess, request);
        feeder.setAbortOnDocumentError(properties.getAbortOnDocumentError());
        feeder.setCreateIfNonExistent(properties.getCreateIfNonExistent());
        response.setAbortOnFeedError(properties.getAbortOnFeedError());
        List<String> errors = feeder.parse();
        for (String s : errors) {
            response.addXMLParseError(s);
        }
        sender.done();
        feedAccess.close();
        long millis = this.getTimeoutMillis(request);
        boolean completed = sender.waitForPending(millis);
        if (!completed) {
            response.addError(new Error(200009, "Timed out after " + millis + " ms waiting for responses"));
        }
        response.done();
        return response;
    }

    private Feeder createFeeder(SimpleFeedAccess sender, InputStreamRequest request) {
        if (!Boolean.parseBoolean(request.getProperty(JSON_INPUT))) {
            return new XMLFeeder(this.getDocumentTypeManager(), sender, this.getRequestInputStream(request));
        }
        return new JsonFeeder(this.getDocumentTypeManager(), sender, this.getRequestInputStream(request));
    }
}

