/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedhandler;

import com.yahoo.clientmetrics.RouteMetricSet;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.feedapi.SharedSender;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class FeedResponse
implements SharedSender.ResultCallback {
    private static final Logger log = Logger.getLogger(FeedResponse.class.getName());
    private final List<String> errors = new ArrayList<String>();
    private final StringBuilder traces = new StringBuilder();
    private final RouteMetricSet metrics;
    private boolean abortOnError = false;
    private boolean isAborted = false;
    private final SharedSender.Pending pendingNumber = new SharedSender.Pending();

    FeedResponse(RouteMetricSet metrics) {
        this.metrics = metrics;
    }

    @Override
    public boolean isAborted() {
        return this.isAborted;
    }

    void setAbortOnFeedError(boolean abort) {
        this.abortOnError = abort;
    }

    private String prettyPrint(Message m) {
        if (m instanceof PutDocumentMessage) {
            return "PUT[" + ((PutDocumentMessage)m).getDocumentPut().getDocument().getId() + "] ";
        }
        if (m instanceof RemoveDocumentMessage) {
            return "REMOVE[" + ((RemoveDocumentMessage)m).getDocumentId() + "] ";
        }
        if (m instanceof UpdateDocumentMessage) {
            return "UPDATE[" + ((UpdateDocumentMessage)m).getDocumentUpdate().getId() + "] ";
        }
        return "";
    }

    @Override
    public synchronized boolean handleReply(Reply reply) {
        this.metrics.addReply(reply);
        if (reply.getTrace().getLevel() > 0) {
            String str = reply.getTrace().toString();
            this.traces.append(str);
            System.out.println(str);
        }
        if (FeedResponse.containsFatalErrors(reply.getErrors())) {
            for (int i = 0; i < reply.getNumErrors(); ++i) {
                Error err = reply.getError(i);
                StringBuilder out = new StringBuilder(this.prettyPrint(reply.getMessage()));
                out.append("[").append(DocumentProtocol.getErrorName((int)err.getCode())).append("] ");
                if (err.getService() != null) {
                    out.append("(").append(err.getService()).append(") ");
                }
                out.append(err.getMessage());
                String str = out.toString();
                log.finest(str);
                this.addError(err);
            }
            if (this.abortOnError) {
                this.isAborted = true;
                return false;
            }
        }
        return true;
    }

    @Override
    public SharedSender.Pending getPending() {
        return this.pendingNumber;
    }

    public void done() {
        this.metrics.done();
    }

    FeedResponse addXMLParseError(String error) {
        this.errors.add(error);
        return this;
    }

    public FeedResponse addError(Error error) {
        this.errors.add(error.toString());
        return this;
    }

    public List<String> getErrorList() {
        return this.errors;
    }

    private static boolean containsFatalErrors(Stream<Error> errors) {
        return errors.anyMatch(e -> e.getCode() != 251013);
    }

    public boolean isSuccess() {
        return this.errors.isEmpty();
    }
}

