/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.concurrent.SystemTimer;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.documentapi.messagebus.protocol.DocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.feedapi.FeederOptions;
import com.yahoo.feedapi.MessageProcessor;
import com.yahoo.feedhandler.InputStreamRequest;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.vespaclient.config.FeederConfig;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MessagePropertyProcessor
implements ConfigSubscriber.SingleSubscriber<FeederConfig> {
    private static final Logger log = Logger.getLogger(MessagePropertyProcessor.class.getName());
    private static final boolean defaultCreateIfNonExistent = false;
    private FeederOptions feederOptions = null;
    private Route defaultRoute = null;
    private long defaultTimeoutMillis = 0L;
    private boolean retryEnabled = true;
    private boolean defaultAbortOnDocumentError = true;
    private boolean defaultAbortOnSendError = true;
    private boolean configChanged = false;

    public MessagePropertyProcessor(FeederConfig config) {
        this.configure(config);
    }

    public void setRoute(String routeOverride) {
        this.defaultRoute = Route.parse((String)routeOverride);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertySetter buildPropertySetter(InputStreamRequest request) {
        boolean createIfNonExistent;
        boolean abortOnFeedError;
        boolean abortOnDocumentError;
        boolean retry;
        long timeout;
        String routeParam = null;
        double timeoutParam = -1.0;
        String priorityParam = null;
        String abortOnDocErrorParam = null;
        String abortOnFeedErrorParam = null;
        String traceStr = null;
        String createIfNonExistentParam = null;
        Double totalTimeoutParam = null;
        if (request != null) {
            routeParam = request.getProperty("route");
            String timeoutStr = request.getProperty("timeout");
            if (timeoutStr != null) {
                timeoutParam = Double.parseDouble(timeoutStr);
            }
            if ((timeoutStr = request.getProperty("totaltimeout")) != null) {
                totalTimeoutParam = Double.parseDouble(timeoutStr);
            }
            priorityParam = request.getProperty("priority");
            traceStr = request.getProperty("tracelevel");
            abortOnDocErrorParam = request.getProperty("abortondocumenterror");
            abortOnFeedErrorParam = request.getProperty("abortonfeederror");
            createIfNonExistentParam = request.getProperty("createifnonexistent");
        }
        Route route = routeParam != null ? Route.parse((String)routeParam) : null;
        MessagePropertyProcessor messagePropertyProcessor = this;
        synchronized (messagePropertyProcessor) {
            if (route == null) {
                route = this.defaultRoute;
            }
            timeout = timeoutParam < 0.0 ? this.defaultTimeoutMillis : (long)(timeoutParam * 1000.0);
            retry = this.retryEnabled;
            boolean bl = abortOnDocErrorParam == null ? this.defaultAbortOnDocumentError : (abortOnDocumentError = !"false".equals(abortOnDocErrorParam));
            abortOnFeedError = abortOnFeedErrorParam == null ? this.defaultAbortOnSendError : !"false".equals(abortOnFeedErrorParam);
            createIfNonExistent = createIfNonExistentParam == null ? false : "true".equals(createIfNonExistentParam);
        }
        long totalTimeout = totalTimeoutParam == null ? timeout : (long)(totalTimeoutParam * 1000.0);
        DocumentProtocol.Priority priority = null;
        if (priorityParam != null) {
            priority = DocumentProtocol.getPriorityByName((String)priorityParam);
        }
        return new PropertySetter(route, timeout, totalTimeout, priority, retry, abortOnDocumentError, abortOnFeedError, createIfNonExistent, traceStr != null ? Integer.parseInt(traceStr) : 0);
    }

    public long getDefaultTimeoutMillis() {
        return this.defaultTimeoutMillis;
    }

    synchronized boolean configChanged() {
        return this.configChanged;
    }

    synchronized void setConfigChanged(boolean configChanged) {
        this.configChanged = configChanged;
    }

    synchronized FeederOptions getFeederOptions() {
        return this.feederOptions;
    }

    public synchronized void configure(FeederConfig config) {
        if (this.feederOptions != null) {
            this.setConfigChanged(true);
        }
        this.feederOptions = new FeederOptions(config);
        this.defaultRoute = this.feederOptions.getRoute() != null ? Route.parse((String)this.feederOptions.getRoute()) : null;
        this.defaultTimeoutMillis = (long)(this.feederOptions.getTimeout() * 1000.0);
        this.retryEnabled = this.feederOptions.getRetryEnabled();
        this.defaultAbortOnDocumentError = this.feederOptions.abortOnDocumentError();
        this.defaultAbortOnSendError = this.feederOptions.abortOnSendError();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Received new config (route: " + (this.defaultRoute != null ? this.defaultRoute : "<none>") + ", timeout: " + this.defaultTimeoutMillis + " ms, retry enabled: " + this.retryEnabled + ", abort on doc error: " + this.defaultAbortOnDocumentError + ", abort on feed error: " + this.defaultAbortOnSendError + ")");
        }
    }

    public class PropertySetter
    implements MessageProcessor {
        private Route route;
        private final long timeout;
        private final long totalTimeout;
        private final long startTime;
        private DocumentProtocol.Priority priority;
        private final boolean retryEnabled;
        private final boolean abortOnDocumentError;
        private final boolean abortOnFeedError;
        private final boolean createIfNonExistent;
        private final int traceLevel;

        PropertySetter(Route route, long timeout, long totalTimeout, DocumentProtocol.Priority priority, boolean retryEnabled, boolean abortOnDocumentError, boolean abortOnFeedError, boolean createIfNonExistent, int traceLevel) {
            this.route = route;
            this.timeout = timeout;
            this.totalTimeout = totalTimeout;
            this.priority = priority;
            this.retryEnabled = retryEnabled;
            this.abortOnDocumentError = abortOnDocumentError;
            this.abortOnFeedError = abortOnFeedError;
            this.createIfNonExistent = createIfNonExistent;
            this.traceLevel = traceLevel;
            this.startTime = SystemTimer.INSTANCE.milliTime();
        }

        private long getTimeRemaining() {
            return this.totalTimeout < 0L ? this.timeout : Math.min(this.timeout, this.totalTimeout - (SystemTimer.INSTANCE.milliTime() - this.startTime));
        }

        public Route getRoute() {
            return this.route;
        }

        public void setRoute(Route route) {
            this.route = route;
        }

        public DocumentProtocol.Priority getPriority() {
            return this.priority;
        }

        public void setPriority(DocumentProtocol.Priority priority) {
            this.priority = priority;
        }

        public boolean getAbortOnDocumentError() {
            return this.abortOnDocumentError;
        }

        public boolean getAbortOnFeedError() {
            return this.abortOnFeedError;
        }

        public boolean getCreateIfNonExistent() {
            return this.createIfNonExistent;
        }

        @Override
        public void process(Message msg) {
            if (this.route != null) {
                msg.setRoute(this.route);
            }
            msg.setTimeRemaining(this.getTimeRemaining());
            msg.setRetryEnabled(this.retryEnabled);
            msg.getTrace().setLevel(Math.max(MessagePropertyProcessor.this.getFeederOptions().getTraceLevel(), this.traceLevel));
            if (this.priority != null) {
                ((DocumentMessage)msg).setPriority(this.priority);
            }
        }
    }
}

