/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi.resource;

import com.yahoo.document.DocumentId;
import com.yahoo.document.restapi.resource.Group;
import com.yahoo.document.restapi.resource.Parser;
import com.yahoo.restapi.Path;
import java.util.Objects;
import java.util.Optional;

class DocumentPath {
    private static final Parser<Long> unsignedLongParser = Long::parseUnsignedLong;
    private final Path path;
    private final String rawPath;
    private final Optional<Group> group;

    DocumentPath(Path path, String rawPath) {
        this.path = Objects.requireNonNull(path);
        this.rawPath = Objects.requireNonNull(rawPath);
        this.group = Optional.ofNullable(path.get("number")).map(unsignedLongParser::parse).map(Group::of).or(() -> Optional.ofNullable(path.get("group")).map(Group::of));
    }

    DocumentId id() {
        return new DocumentId("id:" + Objects.requireNonNull(this.path.get("namespace")) + ":" + Objects.requireNonNull(this.path.get("documentType")) + ":" + this.group.map(Group::docIdPart).orElse("") + ":" + String.join((CharSequence)"/", Objects.requireNonNull(this.path.getRest()).segments()));
    }

    String rawPath() {
        return this.rawPath;
    }

    Optional<String> documentType() {
        return Optional.ofNullable(this.path.get("documentType"));
    }

    Optional<String> namespace() {
        return Optional.ofNullable(this.path.get("namespace"));
    }

    Optional<Group> group() {
        return this.group;
    }
}

