/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import com.yahoo.api.annotations.Beta;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

@Beta
public class OperationStats {
    private final double duration;
    private final long requests;
    private final long inflight;
    private final long targetInflight;
    private final long exceptions;
    private final long bytesSent;
    private final long averageLatencyMillis;
    private final long minLatencyMillis;
    private final long maxLatencyMillis;
    private final Map<Integer, Response> statsByCode;

    public OperationStats(double duration, long requests, long exceptions, long inflight, long targetInFlight, long bytesSent, long averageLatencyMillis, long minLatencyMillis, long maxLatencyMillis, Map<Integer, Response> statsByCode) {
        this.duration = duration;
        this.requests = requests;
        this.exceptions = exceptions;
        this.inflight = inflight;
        this.targetInflight = targetInFlight;
        this.bytesSent = bytesSent;
        this.averageLatencyMillis = averageLatencyMillis;
        this.minLatencyMillis = minLatencyMillis;
        this.maxLatencyMillis = maxLatencyMillis;
        this.statsByCode = statsByCode;
    }

    public long requests() {
        return this.requests;
    }

    public long responses() {
        return this.statsByCode.values().stream().mapToLong(r -> r.count).sum();
    }

    public long successes() {
        Response okStats = this.statsByCode.get(200);
        if (okStats == null) {
            return 0L;
        }
        return okStats.count;
    }

    public Map<Integer, Response> statsByCode() {
        return this.statsByCode;
    }

    public Duration duration() {
        return Duration.ofNanos((long)(this.duration * 1.0E9));
    }

    public Optional<Response> response(int code) {
        return Optional.ofNullable(this.statsByCode.get(code));
    }

    public long exceptions() {
        return this.exceptions;
    }

    public long inflight() {
        return this.inflight;
    }

    public long averageLatencyMillis() {
        long responses = this.responses();
        if (responses == 0L) {
            return -1L;
        }
        long totalLatencyMillis = this.statsByCode.values().stream().mapToLong(r -> r.totalLatencyMillis).sum();
        return totalLatencyMillis / responses;
    }

    public long minLatencyMillis() {
        return this.statsByCode.values().stream().mapToLong(r -> r.minLatencyMillis).min().orElse(-1L);
    }

    public long maxLatencyMillis() {
        return this.statsByCode.values().stream().mapToLong(r -> r.maxLatencyMillis).max().orElse(-1L);
    }

    public long bytesSent() {
        return this.bytesSent;
    }

    public long bytesReceived() {
        return this.statsByCode.values().stream().mapToLong(r -> r.bytesReceived).sum();
    }

    public long operationAverageLatencyMillis() {
        return this.averageLatencyMillis;
    }

    public long operationMinLatencyMillis() {
        return this.minLatencyMillis;
    }

    public long operationMaxLatencyMillis() {
        return this.maxLatencyMillis;
    }

    public String toString() {
        return "OperationStats{duration=" + this.duration + ", requests=" + this.requests + ", inflight=" + this.inflight + ", targetInflight=" + this.targetInflight + ", exceptions=" + this.exceptions + ", bytesSent=" + this.bytesSent + ", averageLatencyMillis=" + this.averageLatencyMillis + ", minLatencyMillis=" + this.minLatencyMillis + ", maxLatencyMillis=" + this.maxLatencyMillis + ", statsByCode=" + String.valueOf(this.statsByCode) + "}";
    }

    public static class Response {
        private final long count;
        private final long totalLatencyMillis;
        private final long averageLatencyMillis;
        private final long minLatencyMillis;
        private final long maxLatencyMillis;
        private final long bytesReceived;
        private final double rate;

        public Response(long count, long totalLatencyMillis, long averageLatencyMillis, long minLatencyMillis, long maxLatencyMillis, long bytesReceived, double rate) {
            this.count = count;
            this.totalLatencyMillis = totalLatencyMillis;
            this.averageLatencyMillis = averageLatencyMillis;
            this.minLatencyMillis = minLatencyMillis;
            this.maxLatencyMillis = maxLatencyMillis;
            this.bytesReceived = bytesReceived;
            this.rate = rate;
        }

        public long count() {
            return this.count;
        }

        public long averageLatencyMillis() {
            return this.averageLatencyMillis;
        }

        public long minLatencyMillis() {
            return this.minLatencyMillis;
        }

        public long maxLatencyMillis() {
            return this.maxLatencyMillis;
        }

        public long bytesReceived() {
            return this.bytesReceived;
        }

        public double rate() {
            return this.rate;
        }

        public String toString() {
            return "Response{count=" + this.count + ", totalLatencyMillis=" + this.totalLatencyMillis + ", averageLatencyMillis=" + this.averageLatencyMillis + ", minLatencyMillis=" + this.minLatencyMillis + ", maxLatencyMillis=" + this.maxLatencyMillis + ", bytesReceived=" + this.bytesReceived + ", rate=" + this.rate + "}";
        }
    }
}

