/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import com.yahoo.container.plugin.mojo.Compression;
import com.yahoo.container.plugin.mojo.Version;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="packageApplication", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class ApplicationMojo
extends AbstractMojo {
    private static final List<String> IGNORED_FILES = List.of(".DS_Store");
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="vespaversion")
    private String vespaversion;
    @Parameter(defaultValue="src/main/application")
    private String sourceDir;
    @Parameter(defaultValue="target/application")
    private String destinationDir;

    public void execute() throws MojoExecutionException {
        File applicationPackage = new File(this.project.getBasedir(), this.sourceDir);
        File applicationDestination = new File(this.project.getBasedir(), this.destinationDir);
        this.copyApplicationPackage(applicationPackage, applicationDestination);
        this.addBuildMetaData(applicationDestination);
        File componentsDir = this.createComponentsDir(applicationDestination);
        this.copyModuleBundles(this.project.getBasedir(), componentsDir);
        this.copyBundlesForSubModules(componentsDir);
        try {
            Compression.zipDirectory(applicationDestination, "");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed zipping application.", e);
        }
    }

    private void addBuildMetaData(File applicationDestination) throws MojoExecutionException {
        Version compileVersion;
        if (!applicationDestination.exists()) {
            return;
        }
        if (this.vespaversion == null) {
            this.vespaversion = this.project.getPlugin("com.yahoo.vespa:vespa-application-maven-plugin").getVersion();
        }
        if ((compileVersion = Version.from(this.vespaversion)).isSnapshot()) {
            return;
        }
        MavenProject current = this.project;
        while (current.getParent() != null && current.getParent().getParentArtifact() != null) {
            current = current.getParent();
        }
        Version parentVersion = null;
        Artifact parentArtifact = current.getParentArtifact();
        if (parentArtifact != null && ApplicationMojo.isVespaParent(parentArtifact.getGroupId())) {
            try {
                parentVersion = Version.from(parentArtifact.getSelectedVersion().toString());
            }
            catch (ArtifactResolutionException e) {
                parentVersion = Version.from(parentArtifact.getVersion());
            }
            if (parentVersion.compareTo(compileVersion) < 0) {
                throw new IllegalArgumentException("compile version (" + String.valueOf(compileVersion) + ") cannot be higher than parent version (" + String.valueOf(parentVersion) + ")");
            }
        }
        String metaData = String.format("{\n  \"compileVersion\": \"%s\",\n  \"buildTime\": %d,\n  \"parentVersion\": %s\n}\n", compileVersion, System.currentTimeMillis(), parentVersion == null ? null : "\"" + String.valueOf(parentVersion) + "\"");
        try {
            Files.writeString(applicationDestination.toPath().resolve("build-meta.json"), (CharSequence)metaData, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed writing compile version and build time.", (Exception)e);
        }
    }

    static boolean isVespaParent(String groupId) {
        return groupId.matches("(com\\.yahoo\\.vespa|ai\\.vespa)(\\..+)?");
    }

    private void copyBundlesForSubModules(File componentsDir) throws MojoExecutionException {
        List<String> modules = ApplicationMojo.emptyListIfNull(this.project.getModules());
        for (String module : modules) {
            File moduleDir = new File(this.project.getBasedir(), module);
            if (!moduleDir.exists()) continue;
            this.copyModuleBundles(moduleDir, componentsDir);
        }
    }

    private File createComponentsDir(File applicationDestination) throws MojoExecutionException {
        File componentsDir = new File(applicationDestination, "components");
        componentsDir.mkdirs();
        if (!componentsDir.exists() || !componentsDir.isDirectory()) {
            throw new MojoExecutionException("Failed creating components directory (" + String.valueOf(componentsDir) + ")");
        }
        return componentsDir;
    }

    private void copyApplicationPackage(File applicationPackage, File applicationDestination) throws MojoExecutionException {
        if (applicationPackage.exists()) {
            try {
                FileUtils.copyDirectory((File)applicationPackage, (File)applicationDestination, (FileFilter)ApplicationMojo.ignoredFilesFilter());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed copying applicationPackage", (Exception)e);
            }
        }
    }

    static FileFilter ignoredFilesFilter() {
        List<IOFileFilter> ioFileFilters = IGNORED_FILES.stream().map(NameFileFilter::new).map(IOFileFilter.class::cast).toList();
        return new NotFileFilter((IOFileFilter)new OrFileFilter(ioFileFilters));
    }

    private void copyModuleBundles(File moduleDir, File componentsDir) throws MojoExecutionException {
        File moduleTargetDir = new File(moduleDir, "target");
        if (moduleTargetDir.exists()) {
            File[] bundles = moduleTargetDir.listFiles((dir, name) -> name.endsWith("-deploy.jar") || name.endsWith("-bundle.jar") || name.endsWith("-jar-with-dependencies.jar"));
            if (bundles == null) {
                return;
            }
            for (File bundle : bundles) {
                try {
                    this.copyFile(bundle, new File(componentsDir, bundle.getName()));
                    this.getLog().info((CharSequence)("Copying bundle to application: " + bundle.getName()));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed copying bundle " + String.valueOf(bundle), (Exception)e);
                }
            }
        }
    }

    private void copyFile(File source, File destination) throws IOException {
        try (FileInputStream sourceStream = new FileInputStream(source);
             FileOutputStream destinationStream = new FileOutputStream(destination);){
            sourceStream.transferTo(destinationStream);
        }
    }

    private static <T> List<T> emptyListIfNull(List<T> modules) {
        return modules == null ? List.of() : modules;
    }
}

