// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of stor-visitordispatcher
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class StorVisitordispatcherConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "92d10d053137ebd51c88d1f1db9edf10";
  public final static String CONFIG_DEF_NAME = "stor-visitordispatcher";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content.core",
    "maxvisitorspernodeperclientvisitor int default=16",
    "minbucketspervisitor int default=1"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer maxvisitorspernodeperclientvisitor = null;
    private Integer minbucketspervisitor = null;

    public Builder() { }

    public Builder(StorVisitordispatcherConfig config) {
      maxvisitorspernodeperclientvisitor(config.maxvisitorspernodeperclientvisitor());
      minbucketspervisitor(config.minbucketspervisitor());
    }

    private Builder override(Builder __superior) {
      if (__superior.maxvisitorspernodeperclientvisitor != null)
        maxvisitorspernodeperclientvisitor(__superior.maxvisitorspernodeperclientvisitor);
      if (__superior.minbucketspervisitor != null)
        minbucketspervisitor(__superior.minbucketspervisitor);
      return this;
    }

    public Builder maxvisitorspernodeperclientvisitor(int __value) {
      maxvisitorspernodeperclientvisitor = __value;
      return this;
    }

    private Builder maxvisitorspernodeperclientvisitor(String __value) {
      return maxvisitorspernodeperclientvisitor(Integer.valueOf(__value));
    }

    public Builder minbucketspervisitor(int __value) {
      minbucketspervisitor = __value;
      return this;
    }

    private Builder minbucketspervisitor(String __value) {
      return minbucketspervisitor(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public StorVisitordispatcherConfig build() {
      return new StorVisitordispatcherConfig(this);
    }

  }

  // For any given client visitor operation, this specifies a maximum fan-out
  // factor for concurrent content node visitor operations towards a particular
  // content node.
  // Having several visitor operations running concurrently increases the
  // potential data processing parallelism on the content nodes at the expense
  // of using additional resources.
  private final IntegerNode maxvisitorspernodeperclientvisitor;
  // Minimum number of buckets that have to be present on a given content node
  // before more than one visitor operation may be sent in parallel towards it.
  // This config is directly related to maxvisitorspernodeperclientvisitor.
  // Example: with max visitors of 4, min buckets of 5 and total of 40 buckets on
  // a content node, a total of 4 visitors of 10 buckets each will be sent to the
  // node. If min buckets were 20, only 2 visitors of 20 buckets each would be
  // sent.
  private final IntegerNode minbucketspervisitor;

  public StorVisitordispatcherConfig(Builder builder) {
    this(builder, true);
  }

  private StorVisitordispatcherConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "stor-visitordispatcher must be initialized: " + builder.__uninitialized);

    maxvisitorspernodeperclientvisitor = (builder.maxvisitorspernodeperclientvisitor == null) ?
        new IntegerNode(16) : new IntegerNode(builder.maxvisitorspernodeperclientvisitor);
    minbucketspervisitor = (builder.minbucketspervisitor == null) ?
        new IntegerNode(1) : new IntegerNode(builder.minbucketspervisitor);
  }

  /**
   * @return stor-visitordispatcher.maxvisitorspernodeperclientvisitor
   */
  public int maxvisitorspernodeperclientvisitor() {
    return maxvisitorspernodeperclientvisitor.value();
  }

  /**
   * @return stor-visitordispatcher.minbucketspervisitor
   */
  public int minbucketspervisitor() {
    return minbucketspervisitor.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(StorVisitordispatcherConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("stor-visitordispatcher");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
