// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of stor-visitor
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class StorVisitorConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "dc821286779da6a40e6ddcc671bd2b02";
  public final static String CONFIG_DEF_NAME = "stor-visitor";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content.core",
    "visitorthreads int default=16 restart",
    "defaultparalleliterators int default=8",
    "maxconcurrentvisitors int default=64",
    "maxconcurrentvisitors_fixed int default=16",
    "maxconcurrentvisitors_variable int default=64",
    "maxvisitorqueuesize int default=1024",
    "visitor_memory_usage_limit int default=25165824"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer visitorthreads = null;
    private Integer defaultparalleliterators = null;
    private Integer maxconcurrentvisitors = null;
    private Integer maxconcurrentvisitors_fixed = null;
    private Integer maxconcurrentvisitors_variable = null;
    private Integer maxvisitorqueuesize = null;
    private Integer visitor_memory_usage_limit = null;

    public Builder() { }

    public Builder(StorVisitorConfig config) {
      visitorthreads(config.visitorthreads());
      defaultparalleliterators(config.defaultparalleliterators());
      maxconcurrentvisitors(config.maxconcurrentvisitors());
      maxconcurrentvisitors_fixed(config.maxconcurrentvisitors_fixed());
      maxconcurrentvisitors_variable(config.maxconcurrentvisitors_variable());
      maxvisitorqueuesize(config.maxvisitorqueuesize());
      visitor_memory_usage_limit(config.visitor_memory_usage_limit());
    }

    private Builder override(Builder __superior) {
      if (__superior.visitorthreads != null)
        visitorthreads(__superior.visitorthreads);
      if (__superior.defaultparalleliterators != null)
        defaultparalleliterators(__superior.defaultparalleliterators);
      if (__superior.maxconcurrentvisitors != null)
        maxconcurrentvisitors(__superior.maxconcurrentvisitors);
      if (__superior.maxconcurrentvisitors_fixed != null)
        maxconcurrentvisitors_fixed(__superior.maxconcurrentvisitors_fixed);
      if (__superior.maxconcurrentvisitors_variable != null)
        maxconcurrentvisitors_variable(__superior.maxconcurrentvisitors_variable);
      if (__superior.maxvisitorqueuesize != null)
        maxvisitorqueuesize(__superior.maxvisitorqueuesize);
      if (__superior.visitor_memory_usage_limit != null)
        visitor_memory_usage_limit(__superior.visitor_memory_usage_limit);
      return this;
    }

    public Builder visitorthreads(int __value) {
      visitorthreads = __value;
      return this;
    }

    private Builder visitorthreads(String __value) {
      return visitorthreads(Integer.valueOf(__value));
    }

    public Builder defaultparalleliterators(int __value) {
      defaultparalleliterators = __value;
      return this;
    }

    private Builder defaultparalleliterators(String __value) {
      return defaultparalleliterators(Integer.valueOf(__value));
    }

    public Builder maxconcurrentvisitors(int __value) {
      maxconcurrentvisitors = __value;
      return this;
    }

    private Builder maxconcurrentvisitors(String __value) {
      return maxconcurrentvisitors(Integer.valueOf(__value));
    }

    public Builder maxconcurrentvisitors_fixed(int __value) {
      maxconcurrentvisitors_fixed = __value;
      return this;
    }

    private Builder maxconcurrentvisitors_fixed(String __value) {
      return maxconcurrentvisitors_fixed(Integer.valueOf(__value));
    }

    public Builder maxconcurrentvisitors_variable(int __value) {
      maxconcurrentvisitors_variable = __value;
      return this;
    }

    private Builder maxconcurrentvisitors_variable(String __value) {
      return maxconcurrentvisitors_variable(Integer.valueOf(__value));
    }

    public Builder maxvisitorqueuesize(int __value) {
      maxvisitorqueuesize = __value;
      return this;
    }

    private Builder maxvisitorqueuesize(String __value) {
      return maxvisitorqueuesize(Integer.valueOf(__value));
    }

    public Builder visitor_memory_usage_limit(int __value) {
      visitor_memory_usage_limit = __value;
      return this;
    }

    private Builder visitor_memory_usage_limit(String __value) {
      return visitor_memory_usage_limit(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public StorVisitorConfig build() {
      return new StorVisitorConfig(this);
    }

  }

  // Number of separate threads that runs visitors.
  // Keep in sync with #stor-filestor:num_visitor_threads
  private final IntegerNode visitorthreads;
  // The number of buckets that are visited in parallel in a visitor visiting
  // multiple buckets. Default is 8, meaning if you send a create visitor to visit
  // 100 buckets, 8 of them will be visited in parallel.
  private final IntegerNode defaultparalleliterators;
  // Max concurrent visitors (legacy)
  private final IntegerNode maxconcurrentvisitors;
  // Priority-based max concurrent visitors. Fixed is the total number of
  // concurrent visitors that can run for any priorities. Variable
  // increases the concurrency limit for higher priorities, the limit
  // being linear with a messages priority. Example: if Fixed is 16
  // and Variable is 64, maxconcurrent for a pri 255 message is 16 and
  // maxconcurrent for a pri 0 message is 16+64=80.
  // If fixed is left as 0, it will take the value of maxconcurrentvisitors,
  // allowing backwards compatability
  private final IntegerNode maxconcurrentvisitors_fixed;
  private final IntegerNode maxconcurrentvisitors_variable;
  // Max size of visitor priority queue
  private final IntegerNode maxvisitorqueuesize;
  // Limit of memory used _per visitor_ in bytes.
  // Due to optimistic parallelization, it is possible for this limit to be
  // initially violated when the visitor is first started. This can happen since
  // the visitor does not know the size of the bucket contents before fetching
  // any data from it and it will do so based on parallelization factors specified
  // in the CreateVisitor command. If 3 buckets are initially visited in parallel
  // and these both contain a single 100 MiB document, the memory usage of the
  // visitor will peak at 300 MiB even if the configured limit is e.g. 20 MiB.
  // Default value is set to 20 MiB, which attempts to keep a reasonably safe
  // level in the face of a default number of max concurrent visitors (64).
  private final IntegerNode visitor_memory_usage_limit;

  public StorVisitorConfig(Builder builder) {
    this(builder, true);
  }

  private StorVisitorConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "stor-visitor must be initialized: " + builder.__uninitialized);

    visitorthreads = (builder.visitorthreads == null) ?
        new IntegerNode(16) : new IntegerNode(builder.visitorthreads);
    defaultparalleliterators = (builder.defaultparalleliterators == null) ?
        new IntegerNode(8) : new IntegerNode(builder.defaultparalleliterators);
    maxconcurrentvisitors = (builder.maxconcurrentvisitors == null) ?
        new IntegerNode(64) : new IntegerNode(builder.maxconcurrentvisitors);
    maxconcurrentvisitors_fixed = (builder.maxconcurrentvisitors_fixed == null) ?
        new IntegerNode(16) : new IntegerNode(builder.maxconcurrentvisitors_fixed);
    maxconcurrentvisitors_variable = (builder.maxconcurrentvisitors_variable == null) ?
        new IntegerNode(64) : new IntegerNode(builder.maxconcurrentvisitors_variable);
    maxvisitorqueuesize = (builder.maxvisitorqueuesize == null) ?
        new IntegerNode(1024) : new IntegerNode(builder.maxvisitorqueuesize);
    visitor_memory_usage_limit = (builder.visitor_memory_usage_limit == null) ?
        new IntegerNode(25165824) : new IntegerNode(builder.visitor_memory_usage_limit);
  }

  /**
   * @return stor-visitor.visitorthreads
   */
  public int visitorthreads() {
    return visitorthreads.value();
  }

  /**
   * @return stor-visitor.defaultparalleliterators
   */
  public int defaultparalleliterators() {
    return defaultparalleliterators.value();
  }

  /**
   * @return stor-visitor.maxconcurrentvisitors
   */
  public int maxconcurrentvisitors() {
    return maxconcurrentvisitors.value();
  }

  /**
   * @return stor-visitor.maxconcurrentvisitors_fixed
   */
  public int maxconcurrentvisitors_fixed() {
    return maxconcurrentvisitors_fixed.value();
  }

  /**
   * @return stor-visitor.maxconcurrentvisitors_variable
   */
  public int maxconcurrentvisitors_variable() {
    return maxconcurrentvisitors_variable.value();
  }

  /**
   * @return stor-visitor.maxvisitorqueuesize
   */
  public int maxvisitorqueuesize() {
    return maxvisitorqueuesize.value();
  }

  /**
   * @return stor-visitor.visitor_memory_usage_limit
   */
  public int visitor_memory_usage_limit() {
    return visitor_memory_usage_limit.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(StorVisitorConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("stor-visitor");
      changes.compare(this.visitorthreads, newConfig.visitorthreads, "visitorthreads", "Number of separate threads that runs visitors.\nKeep in sync with #stor-filestor:num_visitor_threads");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }


}
