// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of stor-status
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class StorStatusConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "ef3394fe3dc9bbed4188ba3e5ecc4626";
  public final static String CONFIG_DEF_NAME = "stor-status";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content.core",
    "httpport int default=0 restart"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer httpport = null;

    public Builder() { }

    public Builder(StorStatusConfig config) {
      httpport(config.httpport());
    }

    private Builder override(Builder __superior) {
      if (__superior.httpport != null)
        httpport(__superior.httpport);
      return this;
    }

    public Builder httpport(int __value) {
      httpport = __value;
      return this;
    }

    private Builder httpport(String __value) {
      return httpport(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public StorStatusConfig build() {
      return new StorStatusConfig(this);
    }

  }

  private final IntegerNode httpport;

  public StorStatusConfig(Builder builder) {
    this(builder, true);
  }

  private StorStatusConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "stor-status must be initialized: " + builder.__uninitialized);

    httpport = (builder.httpport == null) ?
        new IntegerNode(0) : new IntegerNode(builder.httpport);
  }

  /**
   * @return stor-status.httpport
   */
  public int httpport() {
    return httpport.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(StorStatusConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("stor-status");
      changes.compare(this.httpport, newConfig.httpport, "httpport", "");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }


}
