// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of stor-server
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class StorServerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "2425175f5bf8f654ddd2ed5a6c34f70a";
  public final static String CONFIG_DEF_NAME = "stor-server";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content.core",
    "root_folder string restart",
    "cluster_name string default=\"storage\" restart",
    "node_index int default=0 restart",
    "is_distributor bool restart",
    "node_capacity double default=1.0 restart",
    "max_merges_per_node int default=16",
    "max_merge_queue_size int default=100",
    "merge_throttling_policy.type enum { STATIC, DYNAMIC } default=STATIC",
    "merge_throttling_policy.min_window_size int default=16",
    "merge_throttling_policy.max_window_size int default=128",
    "merge_throttling_policy.window_size_increment double default=2.0",
    "merge_throttling_memory_limit.max_usage_bytes long default=0",
    "merge_throttling_memory_limit.auto_phys_mem_scale_factor double default=0.015",
    "merge_throttling_memory_limit.auto_lower_bound_bytes long default=134217728",
    "merge_throttling_memory_limit.auto_upper_bound_bytes long default=1073741824",
    "resource_exhaustion_merge_back_pressure_duration_secs double default=30.0",
    "enable_dead_lock_detector bool default=false",
    "enable_dead_lock_detector_warnings bool default=true",
    "dead_lock_detector_timeout_slack double default=240",
    "persistence_provider.type enum {STORAGE, DUMMY, RPC } default=STORAGE restart",
    "persistence_provider.rpc.connectspec string default=\"tcp/localhost:27777\" restart",
    "bucket_rechecking_chunk_size int default=100",
    "simulated_bucket_request_latency_msec int default=0",
    "content_node_bucket_db_stripe_bits int default=4 restart",
    "write_pid_file_on_startup bool default=true",
    "require_strictly_increasing_cluster_state_versions bool default=true"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "root_folder",
      "is_distributor"
      ));

    private String root_folder = null;
    private String cluster_name = null;
    private Integer node_index = null;
    private Boolean is_distributor = null;
    private Double node_capacity = null;
    private Integer max_merges_per_node = null;
    private Integer max_merge_queue_size = null;
    public Merge_throttling_policy.Builder merge_throttling_policy = new Merge_throttling_policy.Builder();
    public Merge_throttling_memory_limit.Builder merge_throttling_memory_limit = new Merge_throttling_memory_limit.Builder();
    private Double resource_exhaustion_merge_back_pressure_duration_secs = null;
    private Boolean enable_dead_lock_detector = null;
    private Boolean enable_dead_lock_detector_warnings = null;
    private Double dead_lock_detector_timeout_slack = null;
    public Persistence_provider.Builder persistence_provider = new Persistence_provider.Builder();
    private Integer bucket_rechecking_chunk_size = null;
    private Integer simulated_bucket_request_latency_msec = null;
    private Integer content_node_bucket_db_stripe_bits = null;
    private Boolean write_pid_file_on_startup = null;
    private Boolean require_strictly_increasing_cluster_state_versions = null;

    public Builder() { }

    public Builder(StorServerConfig config) {
      root_folder(config.root_folder());
      cluster_name(config.cluster_name());
      node_index(config.node_index());
      is_distributor(config.is_distributor());
      node_capacity(config.node_capacity());
      max_merges_per_node(config.max_merges_per_node());
      max_merge_queue_size(config.max_merge_queue_size());
      merge_throttling_policy(new Merge_throttling_policy.Builder(config.merge_throttling_policy()));
      merge_throttling_memory_limit(new Merge_throttling_memory_limit.Builder(config.merge_throttling_memory_limit()));
      resource_exhaustion_merge_back_pressure_duration_secs(config.resource_exhaustion_merge_back_pressure_duration_secs());
      enable_dead_lock_detector(config.enable_dead_lock_detector());
      enable_dead_lock_detector_warnings(config.enable_dead_lock_detector_warnings());
      dead_lock_detector_timeout_slack(config.dead_lock_detector_timeout_slack());
      persistence_provider(new Persistence_provider.Builder(config.persistence_provider()));
      bucket_rechecking_chunk_size(config.bucket_rechecking_chunk_size());
      simulated_bucket_request_latency_msec(config.simulated_bucket_request_latency_msec());
      content_node_bucket_db_stripe_bits(config.content_node_bucket_db_stripe_bits());
      write_pid_file_on_startup(config.write_pid_file_on_startup());
      require_strictly_increasing_cluster_state_versions(config.require_strictly_increasing_cluster_state_versions());
    }

    private Builder override(Builder __superior) {
      if (__superior.root_folder != null)
        root_folder(__superior.root_folder);
      if (__superior.cluster_name != null)
        cluster_name(__superior.cluster_name);
      if (__superior.node_index != null)
        node_index(__superior.node_index);
      if (__superior.is_distributor != null)
        is_distributor(__superior.is_distributor);
      if (__superior.node_capacity != null)
        node_capacity(__superior.node_capacity);
      if (__superior.max_merges_per_node != null)
        max_merges_per_node(__superior.max_merges_per_node);
      if (__superior.max_merge_queue_size != null)
        max_merge_queue_size(__superior.max_merge_queue_size);
      merge_throttling_policy(merge_throttling_policy.override(__superior.merge_throttling_policy));
      merge_throttling_memory_limit(merge_throttling_memory_limit.override(__superior.merge_throttling_memory_limit));
      if (__superior.resource_exhaustion_merge_back_pressure_duration_secs != null)
        resource_exhaustion_merge_back_pressure_duration_secs(__superior.resource_exhaustion_merge_back_pressure_duration_secs);
      if (__superior.enable_dead_lock_detector != null)
        enable_dead_lock_detector(__superior.enable_dead_lock_detector);
      if (__superior.enable_dead_lock_detector_warnings != null)
        enable_dead_lock_detector_warnings(__superior.enable_dead_lock_detector_warnings);
      if (__superior.dead_lock_detector_timeout_slack != null)
        dead_lock_detector_timeout_slack(__superior.dead_lock_detector_timeout_slack);
      persistence_provider(persistence_provider.override(__superior.persistence_provider));
      if (__superior.bucket_rechecking_chunk_size != null)
        bucket_rechecking_chunk_size(__superior.bucket_rechecking_chunk_size);
      if (__superior.simulated_bucket_request_latency_msec != null)
        simulated_bucket_request_latency_msec(__superior.simulated_bucket_request_latency_msec);
      if (__superior.content_node_bucket_db_stripe_bits != null)
        content_node_bucket_db_stripe_bits(__superior.content_node_bucket_db_stripe_bits);
      if (__superior.write_pid_file_on_startup != null)
        write_pid_file_on_startup(__superior.write_pid_file_on_startup);
      if (__superior.require_strictly_increasing_cluster_state_versions != null)
        require_strictly_increasing_cluster_state_versions(__superior.require_strictly_increasing_cluster_state_versions);
      return this;
    }

    public Builder root_folder(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      root_folder = __value;
      __uninitialized.remove("root_folder");
      return this;
    }


    public Builder cluster_name(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      cluster_name = __value;
      return this;
    }


    public Builder node_index(int __value) {
      node_index = __value;
      return this;
    }

    private Builder node_index(String __value) {
      return node_index(Integer.valueOf(__value));
    }

    public Builder is_distributor(boolean __value) {
      is_distributor = __value;
      __uninitialized.remove("is_distributor");
      return this;
    }

    private Builder is_distributor(String __value) {
      return is_distributor(Boolean.valueOf(__value));
    }

    public Builder node_capacity(double __value) {
      node_capacity = __value;
      return this;
    }

    private Builder node_capacity(String __value) {
      return node_capacity(Double.valueOf(__value));
    }

    public Builder max_merges_per_node(int __value) {
      max_merges_per_node = __value;
      return this;
    }

    private Builder max_merges_per_node(String __value) {
      return max_merges_per_node(Integer.valueOf(__value));
    }

    public Builder max_merge_queue_size(int __value) {
      max_merge_queue_size = __value;
      return this;
    }

    private Builder max_merge_queue_size(String __value) {
      return max_merge_queue_size(Integer.valueOf(__value));
    }

    public Builder merge_throttling_policy(Merge_throttling_policy.Builder __builder) {
      merge_throttling_policy = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder merge_throttling_policy(java.util.function.Consumer<Merge_throttling_policy.Builder> __func) {
      Merge_throttling_policy.Builder __inner = new Merge_throttling_policy.Builder();
      __func.accept(__inner);
      merge_throttling_policy = __inner;
      return this;
    }

    public Builder merge_throttling_memory_limit(Merge_throttling_memory_limit.Builder __builder) {
      merge_throttling_memory_limit = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder merge_throttling_memory_limit(java.util.function.Consumer<Merge_throttling_memory_limit.Builder> __func) {
      Merge_throttling_memory_limit.Builder __inner = new Merge_throttling_memory_limit.Builder();
      __func.accept(__inner);
      merge_throttling_memory_limit = __inner;
      return this;
    }

    public Builder resource_exhaustion_merge_back_pressure_duration_secs(double __value) {
      resource_exhaustion_merge_back_pressure_duration_secs = __value;
      return this;
    }

    private Builder resource_exhaustion_merge_back_pressure_duration_secs(String __value) {
      return resource_exhaustion_merge_back_pressure_duration_secs(Double.valueOf(__value));
    }

    public Builder enable_dead_lock_detector(boolean __value) {
      enable_dead_lock_detector = __value;
      return this;
    }

    private Builder enable_dead_lock_detector(String __value) {
      return enable_dead_lock_detector(Boolean.valueOf(__value));
    }

    public Builder enable_dead_lock_detector_warnings(boolean __value) {
      enable_dead_lock_detector_warnings = __value;
      return this;
    }

    private Builder enable_dead_lock_detector_warnings(String __value) {
      return enable_dead_lock_detector_warnings(Boolean.valueOf(__value));
    }

    public Builder dead_lock_detector_timeout_slack(double __value) {
      dead_lock_detector_timeout_slack = __value;
      return this;
    }

    private Builder dead_lock_detector_timeout_slack(String __value) {
      return dead_lock_detector_timeout_slack(Double.valueOf(__value));
    }

    public Builder persistence_provider(Persistence_provider.Builder __builder) {
      persistence_provider = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder persistence_provider(java.util.function.Consumer<Persistence_provider.Builder> __func) {
      Persistence_provider.Builder __inner = new Persistence_provider.Builder();
      __func.accept(__inner);
      persistence_provider = __inner;
      return this;
    }

    public Builder bucket_rechecking_chunk_size(int __value) {
      bucket_rechecking_chunk_size = __value;
      return this;
    }

    private Builder bucket_rechecking_chunk_size(String __value) {
      return bucket_rechecking_chunk_size(Integer.valueOf(__value));
    }

    public Builder simulated_bucket_request_latency_msec(int __value) {
      simulated_bucket_request_latency_msec = __value;
      return this;
    }

    private Builder simulated_bucket_request_latency_msec(String __value) {
      return simulated_bucket_request_latency_msec(Integer.valueOf(__value));
    }

    public Builder content_node_bucket_db_stripe_bits(int __value) {
      content_node_bucket_db_stripe_bits = __value;
      return this;
    }

    private Builder content_node_bucket_db_stripe_bits(String __value) {
      return content_node_bucket_db_stripe_bits(Integer.valueOf(__value));
    }

    public Builder write_pid_file_on_startup(boolean __value) {
      write_pid_file_on_startup = __value;
      return this;
    }

    private Builder write_pid_file_on_startup(String __value) {
      return write_pid_file_on_startup(Boolean.valueOf(__value));
    }

    public Builder require_strictly_increasing_cluster_state_versions(boolean __value) {
      require_strictly_increasing_cluster_state_versions = __value;
      return this;
    }

    private Builder require_strictly_increasing_cluster_state_versions(String __value) {
      return require_strictly_increasing_cluster_state_versions(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public StorServerConfig build() {
      return new StorServerConfig(this);
    }

  }

  // Root directory for all files related to this storage node.
  // Will typically be "$VESPA_HOME/var/db/vespa/vds/<cluster>/<nodetype>/<index>
  private final StringNode root_folder;
  // VDS cluster
  private final StringNode cluster_name;
  // The index of this node. Each node of the same type in the same cluster need
  // to have unique indexes. This should not be changed, as this is what we use
  // to identify the node, and to decide what data should be on it.
  private final IntegerNode node_index;
  // Set whether this is a distributor or a storage node. This will decide what
  // storage links are set up.
  private final BooleanNode is_distributor;
  // Capacity of the node. How much data and load this node will get relative to
  // other nodes.
  private final DoubleNode node_capacity;
  // The upper bound of merges that any storage node can have active.
  // A merge operation will be chained through all nodes involved in the
  // merge, only actually starting the operation when every node has
  // allowed it to pass through.
  // NOTE: these config values are _not_ used if merge_throttling_policy.type
  // is configured to DYNAMIC (see below).
  private final IntegerNode max_merges_per_node;
  private final IntegerNode max_merge_queue_size;
  private final Merge_throttling_policy merge_throttling_policy;
  private final Merge_throttling_memory_limit merge_throttling_memory_limit;
  // If the persistence provider indicates that it has exhausted one or more
  // of its internal resources during a mutating operation, new merges will
  // be bounced for this duration. Not allowing further merges helps take
  // load off the node while it e.g. compacts its data stores or memory in
  // the background.
  // Note: this does not affect merges where the current node is marked as
  // "source only", as merges do not cause mutations on such nodes.
  private final DoubleNode resource_exhaustion_merge_back_pressure_duration_secs;
  // Whether the deadlock detector should be enabled or not. If disabled, it will
  // still run, but it will never actually abort the process it is running in.
  private final BooleanNode enable_dead_lock_detector;
  // Whether to enable deadlock detector warnings in log or not. If enabled,
  // warnings will be written even if dead lock detecting is not enabled.
  private final BooleanNode enable_dead_lock_detector_warnings;
  // Each thread registers how often it will at minimum register ticks (given that
  // the system is not overloaded. If you are running Vespa on overloaded nodes,
  // you can use this slack timeout to add to the thread timeouts in order to
  // allow for more slack before dead lock detector kicks in. The value is in seconds.
  private final DoubleNode dead_lock_detector_timeout_slack;
  private final Persistence_provider persistence_provider;
  // When the content layer receives a set of changed buckets from the persistence
  // layer, it must recheck all of these. Each such recheck results in an
  // operation scheduled against the persistence queust and since the total
  // number of buckets to recheck may reach hundreds of thousands in a large
  // system, we send these in chunks to avoid saturating the queues with
  // operations.
  private final IntegerNode bucket_rechecking_chunk_size;
  // If greater than zero, simulates added latency caused by CPU processing during
  // full bucket info requests. The latency is added per batch of operations processed.
  // Only useful for testing!
  private final IntegerNode simulated_bucket_request_latency_msec;
  // If non-zero, the bucket DB will be striped into 2^bits sub-databases, each handling
  // a disjoint subset of the node's buckets, in order to reduce locking contention.
  // Max value is unspecified, but will be clamped internally.
  private final IntegerNode content_node_bucket_db_stripe_bits;
  // Iff set, a special `pidfile` file is written under the node's root directory upon
  // startup containing the PID of the running process.
  private final BooleanNode write_pid_file_on_startup;
  // Iff true, received cluster state versions that are lower than the current active
  // (or pending to be active) version on the node will be explicitly rejected. This
  // prevents race conditions caused by multiple cluster controllers believing they
  // are the leader during overlapping time intervals, as only the most recent leader
  // is able to increment the current state version in ZooKeeper, but the old controller
  // may still attempt to publish its old state.
  private final BooleanNode require_strictly_increasing_cluster_state_versions;

  public StorServerConfig(Builder builder) {
    this(builder, true);
  }

  private StorServerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "stor-server must be initialized: " + builder.__uninitialized);

    root_folder = (builder.root_folder == null) ?
        new StringNode() : new StringNode(builder.root_folder);
    cluster_name = (builder.cluster_name == null) ?
        new StringNode("storage") : new StringNode(builder.cluster_name);
    node_index = (builder.node_index == null) ?
        new IntegerNode(0) : new IntegerNode(builder.node_index);
    is_distributor = (builder.is_distributor == null) ?
        new BooleanNode() : new BooleanNode(builder.is_distributor);
    node_capacity = (builder.node_capacity == null) ?
        new DoubleNode(1.0D) : new DoubleNode(builder.node_capacity);
    max_merges_per_node = (builder.max_merges_per_node == null) ?
        new IntegerNode(16) : new IntegerNode(builder.max_merges_per_node);
    max_merge_queue_size = (builder.max_merge_queue_size == null) ?
        new IntegerNode(100) : new IntegerNode(builder.max_merge_queue_size);
    merge_throttling_policy = new Merge_throttling_policy(builder.merge_throttling_policy, throwIfUninitialized);
    merge_throttling_memory_limit = new Merge_throttling_memory_limit(builder.merge_throttling_memory_limit, throwIfUninitialized);
    resource_exhaustion_merge_back_pressure_duration_secs = (builder.resource_exhaustion_merge_back_pressure_duration_secs == null) ?
        new DoubleNode(30.0D) : new DoubleNode(builder.resource_exhaustion_merge_back_pressure_duration_secs);
    enable_dead_lock_detector = (builder.enable_dead_lock_detector == null) ?
        new BooleanNode(false) : new BooleanNode(builder.enable_dead_lock_detector);
    enable_dead_lock_detector_warnings = (builder.enable_dead_lock_detector_warnings == null) ?
        new BooleanNode(true) : new BooleanNode(builder.enable_dead_lock_detector_warnings);
    dead_lock_detector_timeout_slack = (builder.dead_lock_detector_timeout_slack == null) ?
        new DoubleNode(240D) : new DoubleNode(builder.dead_lock_detector_timeout_slack);
    persistence_provider = new Persistence_provider(builder.persistence_provider, throwIfUninitialized);
    bucket_rechecking_chunk_size = (builder.bucket_rechecking_chunk_size == null) ?
        new IntegerNode(100) : new IntegerNode(builder.bucket_rechecking_chunk_size);
    simulated_bucket_request_latency_msec = (builder.simulated_bucket_request_latency_msec == null) ?
        new IntegerNode(0) : new IntegerNode(builder.simulated_bucket_request_latency_msec);
    content_node_bucket_db_stripe_bits = (builder.content_node_bucket_db_stripe_bits == null) ?
        new IntegerNode(4) : new IntegerNode(builder.content_node_bucket_db_stripe_bits);
    write_pid_file_on_startup = (builder.write_pid_file_on_startup == null) ?
        new BooleanNode(true) : new BooleanNode(builder.write_pid_file_on_startup);
    require_strictly_increasing_cluster_state_versions = (builder.require_strictly_increasing_cluster_state_versions == null) ?
        new BooleanNode(true) : new BooleanNode(builder.require_strictly_increasing_cluster_state_versions);
  }

  /**
   * @return stor-server.root_folder
   */
  public String root_folder() {
    return root_folder.value();
  }

  /**
   * @return stor-server.cluster_name
   */
  public String cluster_name() {
    return cluster_name.value();
  }

  /**
   * @return stor-server.node_index
   */
  public int node_index() {
    return node_index.value();
  }

  /**
   * @return stor-server.is_distributor
   */
  public boolean is_distributor() {
    return is_distributor.value();
  }

  /**
   * @return stor-server.node_capacity
   */
  public double node_capacity() {
    return node_capacity.value();
  }

  /**
   * @return stor-server.max_merges_per_node
   */
  public int max_merges_per_node() {
    return max_merges_per_node.value();
  }

  /**
   * @return stor-server.max_merge_queue_size
   */
  public int max_merge_queue_size() {
    return max_merge_queue_size.value();
  }

  /**
   * @return stor-server.merge_throttling_policy
   */
  public Merge_throttling_policy merge_throttling_policy() {
    return merge_throttling_policy;
  }

  /**
   * @return stor-server.merge_throttling_memory_limit
   */
  public Merge_throttling_memory_limit merge_throttling_memory_limit() {
    return merge_throttling_memory_limit;
  }

  /**
   * @return stor-server.resource_exhaustion_merge_back_pressure_duration_secs
   */
  public double resource_exhaustion_merge_back_pressure_duration_secs() {
    return resource_exhaustion_merge_back_pressure_duration_secs.value();
  }

  /**
   * @return stor-server.enable_dead_lock_detector
   */
  public boolean enable_dead_lock_detector() {
    return enable_dead_lock_detector.value();
  }

  /**
   * @return stor-server.enable_dead_lock_detector_warnings
   */
  public boolean enable_dead_lock_detector_warnings() {
    return enable_dead_lock_detector_warnings.value();
  }

  /**
   * @return stor-server.dead_lock_detector_timeout_slack
   */
  public double dead_lock_detector_timeout_slack() {
    return dead_lock_detector_timeout_slack.value();
  }

  /**
   * @return stor-server.persistence_provider
   */
  public Persistence_provider persistence_provider() {
    return persistence_provider;
  }

  /**
   * @return stor-server.bucket_rechecking_chunk_size
   */
  public int bucket_rechecking_chunk_size() {
    return bucket_rechecking_chunk_size.value();
  }

  /**
   * @return stor-server.simulated_bucket_request_latency_msec
   */
  public int simulated_bucket_request_latency_msec() {
    return simulated_bucket_request_latency_msec.value();
  }

  /**
   * @return stor-server.content_node_bucket_db_stripe_bits
   */
  public int content_node_bucket_db_stripe_bits() {
    return content_node_bucket_db_stripe_bits.value();
  }

  /**
   * @return stor-server.write_pid_file_on_startup
   */
  public boolean write_pid_file_on_startup() {
    return write_pid_file_on_startup.value();
  }

  /**
   * @return stor-server.require_strictly_increasing_cluster_state_versions
   */
  public boolean require_strictly_increasing_cluster_state_versions() {
    return require_strictly_increasing_cluster_state_versions.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(StorServerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("stor-server");
      changes.compare(this.root_folder, newConfig.root_folder, "root_folder", "Root directory for all files related to this storage node.\nWill typically be \"$VESPA_HOME/var/db/vespa/vds/<cluster>/<nodetype>/<index>");
      changes.compare(this.cluster_name, newConfig.cluster_name, "cluster_name", "VDS cluster");
      changes.compare(this.node_index, newConfig.node_index, "node_index", "The index of this node. Each node of the same type in the same cluster need\nto have unique indexes. This should not be changed, as this is what we use\nto identify the node, and to decide what data should be on it.");
      changes.compare(this.is_distributor, newConfig.is_distributor, "is_distributor", "Set whether this is a distributor or a storage node. This will decide what\nstorage links are set up.");
      changes.compare(this.node_capacity, newConfig.node_capacity, "node_capacity", "Capacity of the node. How much data and load this node will get relative to\nother nodes.");
      changes.mergeChanges("persistence_provider", this.persistence_provider.getChangesRequiringRestart(newConfig.persistence_provider));
      changes.compare(this.content_node_bucket_db_stripe_bits, newConfig.content_node_bucket_db_stripe_bits, "content_node_bucket_db_stripe_bits", "If non-zero, the bucket DB will be striped into 2^bits sub-databases, each handling\na disjoint subset of the node's buckets, in order to reduce locking contention.\nMax value is unspecified, but will be clamped internally.");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }

  /**
   * This class represents stor-server.merge_throttling_policy
   */
  public final static class Merge_throttling_policy extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Type.Enum type = null;
      private Integer min_window_size = null;
      private Integer max_window_size = null;
      private Double window_size_increment = null;

      public Builder() { }

      public Builder(Merge_throttling_policy config) {
        type(config.type());
        min_window_size(config.min_window_size());
        max_window_size(config.max_window_size());
        window_size_increment(config.window_size_increment());
      }

      private Builder override(Builder __superior) {
        if (__superior.type != null)
          type(__superior.type);
        if (__superior.min_window_size != null)
          min_window_size(__superior.min_window_size);
        if (__superior.max_window_size != null)
          max_window_size(__superior.max_window_size);
        if (__superior.window_size_increment != null)
          window_size_increment(__superior.window_size_increment);
        return this;
      }

      public Builder type(Type.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        type = __value;
        return this;
      }

      private Builder type(String __value) {
        return type(Type.Enum.valueOf(__value));
      }

      public Builder min_window_size(int __value) {
        min_window_size = __value;
        return this;
      }

      private Builder min_window_size(String __value) {
        return min_window_size(Integer.valueOf(__value));
      }

      public Builder max_window_size(int __value) {
        max_window_size = __value;
        return this;
      }

      private Builder max_window_size(String __value) {
        return max_window_size(Integer.valueOf(__value));
      }

      public Builder window_size_increment(double __value) {
        window_size_increment = __value;
        return this;
      }

      private Builder window_size_increment(String __value) {
        return window_size_increment(Double.valueOf(__value));
      }

      public Merge_throttling_policy build() {
        return new Merge_throttling_policy(this);
      }

    }

    // Chooses the throttling policy used to control the active merge window size
    // of the MergeThrottler component.
    private final Type type;
    // Only used if merge_throttling_policy.type == DYNAMIC:
    private final IntegerNode min_window_size;
    private final IntegerNode max_window_size;
    private final DoubleNode window_size_increment;

    public Merge_throttling_policy(Builder builder) {
      this(builder, true);
    }

    private Merge_throttling_policy(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "stor-server.merge_throttling_policy must be initialized: " + builder.__uninitialized);

      type = (builder.type == null) ?
          new Type(Type.STATIC) : new Type(builder.type);
      min_window_size = (builder.min_window_size == null) ?
          new IntegerNode(16) : new IntegerNode(builder.min_window_size);
      max_window_size = (builder.max_window_size == null) ?
          new IntegerNode(128) : new IntegerNode(builder.max_window_size);
      window_size_increment = (builder.window_size_increment == null) ?
          new DoubleNode(2.0D) : new DoubleNode(builder.window_size_increment);
    }

    /**
     * @return stor-server.merge_throttling_policy.type
     */
    public Type.Enum type() {
      return type.value();
    }

    /**
     * @return stor-server.merge_throttling_policy.min_window_size
     */
    public int min_window_size() {
      return min_window_size.value();
    }

    /**
     * @return stor-server.merge_throttling_policy.max_window_size
     */
    public int max_window_size() {
      return max_window_size.value();
    }

    /**
     * @return stor-server.merge_throttling_policy.window_size_increment
     */
    public double window_size_increment() {
      return window_size_increment.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Merge_throttling_policy newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("merge_throttling_policy");
      return changes;
    }

    /**
     * This class represents stor-server.merge_throttling_policy.type
     * 
     * Chooses the throttling policy used to control the active merge window size
     * of the MergeThrottler component.
     */
    public final static class Type extends EnumNode<Type.Enum> {

      public Type(){
        this.value = null;
      }

      public Type(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {STATIC, DYNAMIC}
      public final static Enum STATIC = Enum.STATIC;
      public final static Enum DYNAMIC = Enum.DYNAMIC;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }
  }

  /**
   * This class represents stor-server.merge_throttling_memory_limit
   */
  public final static class Merge_throttling_memory_limit extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Long max_usage_bytes = null;
      private Double auto_phys_mem_scale_factor = null;
      private Long auto_lower_bound_bytes = null;
      private Long auto_upper_bound_bytes = null;

      public Builder() { }

      public Builder(Merge_throttling_memory_limit config) {
        max_usage_bytes(config.max_usage_bytes());
        auto_phys_mem_scale_factor(config.auto_phys_mem_scale_factor());
        auto_lower_bound_bytes(config.auto_lower_bound_bytes());
        auto_upper_bound_bytes(config.auto_upper_bound_bytes());
      }

      private Builder override(Builder __superior) {
        if (__superior.max_usage_bytes != null)
          max_usage_bytes(__superior.max_usage_bytes);
        if (__superior.auto_phys_mem_scale_factor != null)
          auto_phys_mem_scale_factor(__superior.auto_phys_mem_scale_factor);
        if (__superior.auto_lower_bound_bytes != null)
          auto_lower_bound_bytes(__superior.auto_lower_bound_bytes);
        if (__superior.auto_upper_bound_bytes != null)
          auto_upper_bound_bytes(__superior.auto_upper_bound_bytes);
        return this;
      }

      public Builder max_usage_bytes(long __value) {
        max_usage_bytes = __value;
        return this;
      }

      private Builder max_usage_bytes(String __value) {
        return max_usage_bytes(Long.valueOf(__value));
      }

      public Builder auto_phys_mem_scale_factor(double __value) {
        auto_phys_mem_scale_factor = __value;
        return this;
      }

      private Builder auto_phys_mem_scale_factor(String __value) {
        return auto_phys_mem_scale_factor(Double.valueOf(__value));
      }

      public Builder auto_lower_bound_bytes(long __value) {
        auto_lower_bound_bytes = __value;
        return this;
      }

      private Builder auto_lower_bound_bytes(String __value) {
        return auto_lower_bound_bytes(Long.valueOf(__value));
      }

      public Builder auto_upper_bound_bytes(long __value) {
        auto_upper_bound_bytes = __value;
        return this;
      }

      private Builder auto_upper_bound_bytes(String __value) {
        return auto_upper_bound_bytes(Long.valueOf(__value));
      }

      public Merge_throttling_memory_limit build() {
        return new Merge_throttling_memory_limit(this);
      }

    }

    // If positive, nodes enforce a soft limit on the estimated amount of memory that
    // can be used by merges touching a particular content node. If a merge arrives
    // to the node that would violate the soft limit, it will be bounced with BUSY.
    // Note that this also counts merges where the node is part of the source-only set,
    // since these use memory when/if data is read from the local node.
    //  
    // Semantics:
    // > 0 explicit limit in bytes
    // == 0 limit automatically deduced by content node
    // < 0 unlimited (legacy behavior)
    private final LongNode max_usage_bytes;
    // If merge_throttling_memory_limit.max_usage_bytes == 0, this factor is used
    // as a multiplier to automatically deduce a memory limit for merges on the
    // content node. Note that the result of this multiplication is capped at both
    // ends by the auto_(lower|upper)_bound_bytes config values.
    //  
    // Default: 1.5% of physical memory
    private final DoubleNode auto_phys_mem_scale_factor;
    // The absolute minimum memory limit that can be set when automatically
    // deducing the limit from physical memory on the node.
    //  
    // Default: 128MiB
    private final LongNode auto_lower_bound_bytes;
    // The absolute maximum memory limit that can be set when automatically
    // deducing the limit from physical memory on the node.
    //  
    // Default: 1GiB
    private final LongNode auto_upper_bound_bytes;

    public Merge_throttling_memory_limit(Builder builder) {
      this(builder, true);
    }

    private Merge_throttling_memory_limit(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "stor-server.merge_throttling_memory_limit must be initialized: " + builder.__uninitialized);

      max_usage_bytes = (builder.max_usage_bytes == null) ?
          new LongNode(0L) : new LongNode(builder.max_usage_bytes);
      auto_phys_mem_scale_factor = (builder.auto_phys_mem_scale_factor == null) ?
          new DoubleNode(0.015D) : new DoubleNode(builder.auto_phys_mem_scale_factor);
      auto_lower_bound_bytes = (builder.auto_lower_bound_bytes == null) ?
          new LongNode(134217728L) : new LongNode(builder.auto_lower_bound_bytes);
      auto_upper_bound_bytes = (builder.auto_upper_bound_bytes == null) ?
          new LongNode(1073741824L) : new LongNode(builder.auto_upper_bound_bytes);
    }

    /**
     * @return stor-server.merge_throttling_memory_limit.max_usage_bytes
     */
    public long max_usage_bytes() {
      return max_usage_bytes.value();
    }

    /**
     * @return stor-server.merge_throttling_memory_limit.auto_phys_mem_scale_factor
     */
    public double auto_phys_mem_scale_factor() {
      return auto_phys_mem_scale_factor.value();
    }

    /**
     * @return stor-server.merge_throttling_memory_limit.auto_lower_bound_bytes
     */
    public long auto_lower_bound_bytes() {
      return auto_lower_bound_bytes.value();
    }

    /**
     * @return stor-server.merge_throttling_memory_limit.auto_upper_bound_bytes
     */
    public long auto_upper_bound_bytes() {
      return auto_upper_bound_bytes.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Merge_throttling_memory_limit newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("merge_throttling_memory_limit");
      return changes;
    }
  }

  /**
   * This class represents stor-server.persistence_provider
   */
  public final static class Persistence_provider extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Type.Enum type = null;
      public Rpc.Builder rpc = new Rpc.Builder();

      public Builder() { }

      public Builder(Persistence_provider config) {
        type(config.type());
        rpc(new Rpc.Builder(config.rpc()));
      }

      private Builder override(Builder __superior) {
        if (__superior.type != null)
          type(__superior.type);
        rpc(rpc.override(__superior.rpc));
        return this;
      }

      public Builder type(Type.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        type = __value;
        return this;
      }

      private Builder type(String __value) {
        return type(Type.Enum.valueOf(__value));
      }

      public Builder rpc(Rpc.Builder __builder) {
        rpc = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder rpc(java.util.function.Consumer<Rpc.Builder> __func) {
        Rpc.Builder __inner = new Rpc.Builder();
        __func.accept(__inner);
        rpc = __inner;
        return this;
      }

      public Persistence_provider build() {
        return new Persistence_provider(this);
      }

    }

    // Configure persistence provider. Temporary here to test.
    private final Type type;
    private final Rpc rpc;

    public Persistence_provider(Builder builder) {
      this(builder, true);
    }

    private Persistence_provider(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "stor-server.persistence_provider must be initialized: " + builder.__uninitialized);

      type = (builder.type == null) ?
          new Type(Type.STORAGE) : new Type(builder.type);
      rpc = new Rpc(builder.rpc, throwIfUninitialized);
    }

    /**
     * @return stor-server.persistence_provider.type
     */
    public Type.Enum type() {
      return type.value();
    }

    /**
     * @return stor-server.persistence_provider.rpc
     */
    public Rpc rpc() {
      return rpc;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Persistence_provider newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("persistence_provider");
        changes.compare(this.type, newConfig.type, "type", "Configure persistence provider. Temporary here to test.");
        changes.mergeChanges("rpc", this.rpc.getChangesRequiringRestart(newConfig.rpc));
      return changes;
    }

    /**
     * This class represents stor-server.persistence_provider.type
     * 
     * Configure persistence provider. Temporary here to test.
     */
    public final static class Type extends EnumNode<Type.Enum> {

      public Type(){
        this.value = null;
      }

      public Type(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {STORAGE, DUMMY, RPC}
      public final static Enum STORAGE = Enum.STORAGE;
      public final static Enum DUMMY = Enum.DUMMY;
      public final static Enum RPC = Enum.RPC;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents stor-server.persistence_provider.rpc
     */
    public final static class Rpc extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private String connectspec = null;

        public Builder() { }

        public Builder(Rpc config) {
          connectspec(config.connectspec());
        }

        private Builder override(Builder __superior) {
          if (__superior.connectspec != null)
            connectspec(__superior.connectspec);
          return this;
        }

        public Builder connectspec(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          connectspec = __value;
          return this;
        }


        public Rpc build() {
          return new Rpc(this);
        }

      }

      private final StringNode connectspec;

      public Rpc(Builder builder) {
        this(builder, true);
      }

      private Rpc(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "stor-server.persistence_provider.rpc must be initialized: " + builder.__uninitialized);

        connectspec = (builder.connectspec == null) ?
            new StringNode("tcp/localhost:27777") : new StringNode(builder.connectspec);
      }

      /**
       * @return stor-server.persistence_provider.rpc.connectspec
       */
      public String connectspec() {
        return connectspec.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Rpc newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("rpc");
          changes.compare(this.connectspec, newConfig.connectspec, "connectspec", "");
        return changes;
      }
    }
  }

}
