// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of stor-distributormanager
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class StorDistributormanagerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "60254e2ab16ba5b78954d366a9c64cff";
  public final static String CONFIG_DEF_NAME = "stor-distributormanager";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content.core",
    "splitsize int default=16772216",
    "splitcount int default=1024",
    "joinsize int default=16000000",
    "joincount int default=512",
    "minsplitcount int default=16",
    "garbagecollection.selectiontoremove string default=\"\"",
    "garbagecollection.interval int default=0",
    "inlinebucketsplitting bool default=true",
    "maximum_nodes_per_merge int default=16",
    "start_distributor_thread bool default=true restart",
    "enable_join_for_sibling_less_buckets bool default=false",
    "enable_inconsistent_join bool default=false",
    "minimum_replica_counting_mode enum { TRUSTED, ANY } default=TRUSTED",
    "disable_bucket_activation bool default=false",
    "max_cluster_clock_skew_sec int default=1",
    "inhibit_merge_sending_on_busy_node_duration_sec int default=1",
    "allow_stale_reads_during_cluster_state_transitions bool default=false",
    "simulated_db_pruning_latency_msec int default=0",
    "simulated_db_merging_latency_msec int default=0",
    "merge_operations_disabled bool default=false",
    "use_weak_internal_read_consistency_for_client_gets bool default=false",
    "max_consecutively_inhibited_maintenance_ticks int default=20",
    "max_activation_inhibited_out_of_sync_groups int default=0",
    "num_distributor_stripes int default=0 restart",
    "enable_operation_cancellation bool default=false",
    "symmetric_put_and_activate_replica_selection bool default=false",
    "max_document_operation_message_size_bytes int default=134217728",
    "priority_merge_out_of_sync_copies int default=120",
    "use_btree_database bool default=true"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer splitsize = null;
    private Integer splitcount = null;
    private Integer joinsize = null;
    private Integer joincount = null;
    private Integer minsplitcount = null;
    public Garbagecollection.Builder garbagecollection = new Garbagecollection.Builder();
    private Boolean inlinebucketsplitting = null;
    private Integer maximum_nodes_per_merge = null;
    private Boolean start_distributor_thread = null;
    private Boolean enable_join_for_sibling_less_buckets = null;
    private Boolean enable_inconsistent_join = null;
    private Minimum_replica_counting_mode.Enum minimum_replica_counting_mode = null;
    private Boolean disable_bucket_activation = null;
    private Integer max_cluster_clock_skew_sec = null;
    private Integer inhibit_merge_sending_on_busy_node_duration_sec = null;
    private Boolean allow_stale_reads_during_cluster_state_transitions = null;
    private Integer simulated_db_pruning_latency_msec = null;
    private Integer simulated_db_merging_latency_msec = null;
    private Boolean merge_operations_disabled = null;
    private Boolean use_weak_internal_read_consistency_for_client_gets = null;
    private Integer max_consecutively_inhibited_maintenance_ticks = null;
    private Integer max_activation_inhibited_out_of_sync_groups = null;
    private Integer num_distributor_stripes = null;
    private Boolean enable_operation_cancellation = null;
    private Boolean symmetric_put_and_activate_replica_selection = null;
    private Integer max_document_operation_message_size_bytes = null;
    private Integer priority_merge_out_of_sync_copies = null;
    private Boolean use_btree_database = null;

    public Builder() { }

    public Builder(StorDistributormanagerConfig config) {
      splitsize(config.splitsize());
      splitcount(config.splitcount());
      joinsize(config.joinsize());
      joincount(config.joincount());
      minsplitcount(config.minsplitcount());
      garbagecollection(new Garbagecollection.Builder(config.garbagecollection()));
      inlinebucketsplitting(config.inlinebucketsplitting());
      maximum_nodes_per_merge(config.maximum_nodes_per_merge());
      start_distributor_thread(config.start_distributor_thread());
      enable_join_for_sibling_less_buckets(config.enable_join_for_sibling_less_buckets());
      enable_inconsistent_join(config.enable_inconsistent_join());
      minimum_replica_counting_mode(config.minimum_replica_counting_mode());
      disable_bucket_activation(config.disable_bucket_activation());
      max_cluster_clock_skew_sec(config.max_cluster_clock_skew_sec());
      inhibit_merge_sending_on_busy_node_duration_sec(config.inhibit_merge_sending_on_busy_node_duration_sec());
      allow_stale_reads_during_cluster_state_transitions(config.allow_stale_reads_during_cluster_state_transitions());
      simulated_db_pruning_latency_msec(config.simulated_db_pruning_latency_msec());
      simulated_db_merging_latency_msec(config.simulated_db_merging_latency_msec());
      merge_operations_disabled(config.merge_operations_disabled());
      use_weak_internal_read_consistency_for_client_gets(config.use_weak_internal_read_consistency_for_client_gets());
      max_consecutively_inhibited_maintenance_ticks(config.max_consecutively_inhibited_maintenance_ticks());
      max_activation_inhibited_out_of_sync_groups(config.max_activation_inhibited_out_of_sync_groups());
      num_distributor_stripes(config.num_distributor_stripes());
      enable_operation_cancellation(config.enable_operation_cancellation());
      symmetric_put_and_activate_replica_selection(config.symmetric_put_and_activate_replica_selection());
      max_document_operation_message_size_bytes(config.max_document_operation_message_size_bytes());
      priority_merge_out_of_sync_copies(config.priority_merge_out_of_sync_copies());
      use_btree_database(config.use_btree_database());
    }

    private Builder override(Builder __superior) {
      if (__superior.splitsize != null)
        splitsize(__superior.splitsize);
      if (__superior.splitcount != null)
        splitcount(__superior.splitcount);
      if (__superior.joinsize != null)
        joinsize(__superior.joinsize);
      if (__superior.joincount != null)
        joincount(__superior.joincount);
      if (__superior.minsplitcount != null)
        minsplitcount(__superior.minsplitcount);
      garbagecollection(garbagecollection.override(__superior.garbagecollection));
      if (__superior.inlinebucketsplitting != null)
        inlinebucketsplitting(__superior.inlinebucketsplitting);
      if (__superior.maximum_nodes_per_merge != null)
        maximum_nodes_per_merge(__superior.maximum_nodes_per_merge);
      if (__superior.start_distributor_thread != null)
        start_distributor_thread(__superior.start_distributor_thread);
      if (__superior.enable_join_for_sibling_less_buckets != null)
        enable_join_for_sibling_less_buckets(__superior.enable_join_for_sibling_less_buckets);
      if (__superior.enable_inconsistent_join != null)
        enable_inconsistent_join(__superior.enable_inconsistent_join);
      if (__superior.minimum_replica_counting_mode != null)
        minimum_replica_counting_mode(__superior.minimum_replica_counting_mode);
      if (__superior.disable_bucket_activation != null)
        disable_bucket_activation(__superior.disable_bucket_activation);
      if (__superior.max_cluster_clock_skew_sec != null)
        max_cluster_clock_skew_sec(__superior.max_cluster_clock_skew_sec);
      if (__superior.inhibit_merge_sending_on_busy_node_duration_sec != null)
        inhibit_merge_sending_on_busy_node_duration_sec(__superior.inhibit_merge_sending_on_busy_node_duration_sec);
      if (__superior.allow_stale_reads_during_cluster_state_transitions != null)
        allow_stale_reads_during_cluster_state_transitions(__superior.allow_stale_reads_during_cluster_state_transitions);
      if (__superior.simulated_db_pruning_latency_msec != null)
        simulated_db_pruning_latency_msec(__superior.simulated_db_pruning_latency_msec);
      if (__superior.simulated_db_merging_latency_msec != null)
        simulated_db_merging_latency_msec(__superior.simulated_db_merging_latency_msec);
      if (__superior.merge_operations_disabled != null)
        merge_operations_disabled(__superior.merge_operations_disabled);
      if (__superior.use_weak_internal_read_consistency_for_client_gets != null)
        use_weak_internal_read_consistency_for_client_gets(__superior.use_weak_internal_read_consistency_for_client_gets);
      if (__superior.max_consecutively_inhibited_maintenance_ticks != null)
        max_consecutively_inhibited_maintenance_ticks(__superior.max_consecutively_inhibited_maintenance_ticks);
      if (__superior.max_activation_inhibited_out_of_sync_groups != null)
        max_activation_inhibited_out_of_sync_groups(__superior.max_activation_inhibited_out_of_sync_groups);
      if (__superior.num_distributor_stripes != null)
        num_distributor_stripes(__superior.num_distributor_stripes);
      if (__superior.enable_operation_cancellation != null)
        enable_operation_cancellation(__superior.enable_operation_cancellation);
      if (__superior.symmetric_put_and_activate_replica_selection != null)
        symmetric_put_and_activate_replica_selection(__superior.symmetric_put_and_activate_replica_selection);
      if (__superior.max_document_operation_message_size_bytes != null)
        max_document_operation_message_size_bytes(__superior.max_document_operation_message_size_bytes);
      if (__superior.priority_merge_out_of_sync_copies != null)
        priority_merge_out_of_sync_copies(__superior.priority_merge_out_of_sync_copies);
      if (__superior.use_btree_database != null)
        use_btree_database(__superior.use_btree_database);
      return this;
    }

    public Builder splitsize(int __value) {
      splitsize = __value;
      return this;
    }

    private Builder splitsize(String __value) {
      return splitsize(Integer.valueOf(__value));
    }

    public Builder splitcount(int __value) {
      splitcount = __value;
      return this;
    }

    private Builder splitcount(String __value) {
      return splitcount(Integer.valueOf(__value));
    }

    public Builder joinsize(int __value) {
      joinsize = __value;
      return this;
    }

    private Builder joinsize(String __value) {
      return joinsize(Integer.valueOf(__value));
    }

    public Builder joincount(int __value) {
      joincount = __value;
      return this;
    }

    private Builder joincount(String __value) {
      return joincount(Integer.valueOf(__value));
    }

    public Builder minsplitcount(int __value) {
      minsplitcount = __value;
      return this;
    }

    private Builder minsplitcount(String __value) {
      return minsplitcount(Integer.valueOf(__value));
    }

    public Builder garbagecollection(Garbagecollection.Builder __builder) {
      garbagecollection = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder garbagecollection(java.util.function.Consumer<Garbagecollection.Builder> __func) {
      Garbagecollection.Builder __inner = new Garbagecollection.Builder();
      __func.accept(__inner);
      garbagecollection = __inner;
      return this;
    }

    public Builder inlinebucketsplitting(boolean __value) {
      inlinebucketsplitting = __value;
      return this;
    }

    private Builder inlinebucketsplitting(String __value) {
      return inlinebucketsplitting(Boolean.valueOf(__value));
    }

    public Builder maximum_nodes_per_merge(int __value) {
      maximum_nodes_per_merge = __value;
      return this;
    }

    private Builder maximum_nodes_per_merge(String __value) {
      return maximum_nodes_per_merge(Integer.valueOf(__value));
    }

    public Builder start_distributor_thread(boolean __value) {
      start_distributor_thread = __value;
      return this;
    }

    private Builder start_distributor_thread(String __value) {
      return start_distributor_thread(Boolean.valueOf(__value));
    }

    public Builder enable_join_for_sibling_less_buckets(boolean __value) {
      enable_join_for_sibling_less_buckets = __value;
      return this;
    }

    private Builder enable_join_for_sibling_less_buckets(String __value) {
      return enable_join_for_sibling_less_buckets(Boolean.valueOf(__value));
    }

    public Builder enable_inconsistent_join(boolean __value) {
      enable_inconsistent_join = __value;
      return this;
    }

    private Builder enable_inconsistent_join(String __value) {
      return enable_inconsistent_join(Boolean.valueOf(__value));
    }

    public Builder minimum_replica_counting_mode(Minimum_replica_counting_mode.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      minimum_replica_counting_mode = __value;
      return this;
    }

    private Builder minimum_replica_counting_mode(String __value) {
      return minimum_replica_counting_mode(Minimum_replica_counting_mode.Enum.valueOf(__value));
    }

    public Builder disable_bucket_activation(boolean __value) {
      disable_bucket_activation = __value;
      return this;
    }

    private Builder disable_bucket_activation(String __value) {
      return disable_bucket_activation(Boolean.valueOf(__value));
    }

    public Builder max_cluster_clock_skew_sec(int __value) {
      max_cluster_clock_skew_sec = __value;
      return this;
    }

    private Builder max_cluster_clock_skew_sec(String __value) {
      return max_cluster_clock_skew_sec(Integer.valueOf(__value));
    }

    public Builder inhibit_merge_sending_on_busy_node_duration_sec(int __value) {
      inhibit_merge_sending_on_busy_node_duration_sec = __value;
      return this;
    }

    private Builder inhibit_merge_sending_on_busy_node_duration_sec(String __value) {
      return inhibit_merge_sending_on_busy_node_duration_sec(Integer.valueOf(__value));
    }

    public Builder allow_stale_reads_during_cluster_state_transitions(boolean __value) {
      allow_stale_reads_during_cluster_state_transitions = __value;
      return this;
    }

    private Builder allow_stale_reads_during_cluster_state_transitions(String __value) {
      return allow_stale_reads_during_cluster_state_transitions(Boolean.valueOf(__value));
    }

    public Builder simulated_db_pruning_latency_msec(int __value) {
      simulated_db_pruning_latency_msec = __value;
      return this;
    }

    private Builder simulated_db_pruning_latency_msec(String __value) {
      return simulated_db_pruning_latency_msec(Integer.valueOf(__value));
    }

    public Builder simulated_db_merging_latency_msec(int __value) {
      simulated_db_merging_latency_msec = __value;
      return this;
    }

    private Builder simulated_db_merging_latency_msec(String __value) {
      return simulated_db_merging_latency_msec(Integer.valueOf(__value));
    }

    public Builder merge_operations_disabled(boolean __value) {
      merge_operations_disabled = __value;
      return this;
    }

    private Builder merge_operations_disabled(String __value) {
      return merge_operations_disabled(Boolean.valueOf(__value));
    }

    public Builder use_weak_internal_read_consistency_for_client_gets(boolean __value) {
      use_weak_internal_read_consistency_for_client_gets = __value;
      return this;
    }

    private Builder use_weak_internal_read_consistency_for_client_gets(String __value) {
      return use_weak_internal_read_consistency_for_client_gets(Boolean.valueOf(__value));
    }

    public Builder max_consecutively_inhibited_maintenance_ticks(int __value) {
      max_consecutively_inhibited_maintenance_ticks = __value;
      return this;
    }

    private Builder max_consecutively_inhibited_maintenance_ticks(String __value) {
      return max_consecutively_inhibited_maintenance_ticks(Integer.valueOf(__value));
    }

    public Builder max_activation_inhibited_out_of_sync_groups(int __value) {
      max_activation_inhibited_out_of_sync_groups = __value;
      return this;
    }

    private Builder max_activation_inhibited_out_of_sync_groups(String __value) {
      return max_activation_inhibited_out_of_sync_groups(Integer.valueOf(__value));
    }

    public Builder num_distributor_stripes(int __value) {
      num_distributor_stripes = __value;
      return this;
    }

    private Builder num_distributor_stripes(String __value) {
      return num_distributor_stripes(Integer.valueOf(__value));
    }

    public Builder enable_operation_cancellation(boolean __value) {
      enable_operation_cancellation = __value;
      return this;
    }

    private Builder enable_operation_cancellation(String __value) {
      return enable_operation_cancellation(Boolean.valueOf(__value));
    }

    public Builder symmetric_put_and_activate_replica_selection(boolean __value) {
      symmetric_put_and_activate_replica_selection = __value;
      return this;
    }

    private Builder symmetric_put_and_activate_replica_selection(String __value) {
      return symmetric_put_and_activate_replica_selection(Boolean.valueOf(__value));
    }

    public Builder max_document_operation_message_size_bytes(int __value) {
      max_document_operation_message_size_bytes = __value;
      return this;
    }

    private Builder max_document_operation_message_size_bytes(String __value) {
      return max_document_operation_message_size_bytes(Integer.valueOf(__value));
    }

    public Builder priority_merge_out_of_sync_copies(int __value) {
      priority_merge_out_of_sync_copies = __value;
      return this;
    }

    private Builder priority_merge_out_of_sync_copies(String __value) {
      return priority_merge_out_of_sync_copies(Integer.valueOf(__value));
    }

    public Builder use_btree_database(boolean __value) {
      use_btree_database = __value;
      return this;
    }

    private Builder use_btree_database(String __value) {
      return use_btree_database(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public StorDistributormanagerConfig build() {
      return new StorDistributormanagerConfig(this);
    }

  }

  // The total size of unique documents in a bucket before we split it due to
  // being too big. By default this is now 16 MB. Should be kept in sync with stor-filestor.def:bucket_merge_chunk_size.
  private final IntegerNode splitsize;
  // The maximum amount of entries in a file before we should attempt to split it.
  // A meta data entry in a slotfile currently uses 40 bytes. It is probably
  // good to have the split size, such that all meta data entries are normally
  // read when you do the initial read. With the default of 1024, meta data will
  // take up around 40 kB, and the default initial read is 64 kB, allowing the
  // file to grow a bit above max and still all be read in initial read.
  private final IntegerNode splitcount;
  // The maximum size of unique documents that allows the system to reduce
  // the number of split bits on the bucket, or join two buckets together.
  // The size must be lower than this number, and the count must be lower than
  // joincount.
  private final IntegerNode joinsize;
  // The maximum number of unique documents that allows for joining (see
  // joinsize).
  private final IntegerNode joincount;
  // Minimum level of splitting for buckets
  private final IntegerNode minsplitcount;
  private final Garbagecollection garbagecollection;
  // If false, dont do splits inline with feeding.
  private final BooleanNode inlinebucketsplitting;
  // Maximum nodes involved in a merge operation. Currently, this can not be more
  // than 16 nodes due to protocol limitations. However, decreasing the max may
  // be useful if 16 node merges ends up too expensive.
  private final IntegerNode maximum_nodes_per_merge;
  // For internal in process debugging, it may be useful to not start the
  // distributor thread to be able to call tick() manually and run single threaded
  private final BooleanNode start_distributor_thread;
  // The distributor can send joins that "lift" a bucket without any siblings
  // higher up in the bucket tree hierarchy. The assumption is that if this
  // is done for all sibling-less buckets, they will all eventually reach a
  // level in the tree where they do in fact have a sibling and may (if their
  // sizes allow) be joined into a single bucket.
  private final BooleanNode enable_join_for_sibling_less_buckets;
  // There exists a distribution edge case where bucket siblings end up having
  // non-equal ideal locations. This will normally inhibit join operations, as
  // these are only allowed when all nodes have all source buckets involved in
  // the join operation. Setting this property to true means such buckets may
  // still be joined at the cost of transient inconsistencies for the buckets
  // being joined into.
  private final BooleanNode enable_inconsistent_join;
  // For each available node, the distributor will report back to the cluster
  // controller a value which indicates the minimum replication factor for any
  // bucket contained on said node. This config exposes a way to alter how this
  // replication factor is computed.
  //  
  // Valid enum values and their semantics:
  //  
  // TRUSTED - only trusted replicas are counted.
  // ANY - any replica present is counted. This may return an overly optimistic
  // view of the system. E.g. if there are 3 replicas, 1 having 1000 docs
  // and 2 having 1 doc, all being out of sync, counting with ANY will still
  // treat this as a minimum replication factor of 3. Conversely, with
  // TRUSTED such a bucket would most likely have a factor of 0 (or 1 iff
  // the trusted status for the replica with 1000 docs is known).
  private final Minimum_replica_counting_mode minimum_replica_counting_mode;
  // Bucket activation only makes sense for indexed search clusters, but Proton
  // may also be run in store-only or streaming mode, in which case it does not
  // actually require any activations. If the model infers that Proton is running
  // in such a mode, activation will be explicitly disabled.
  //  
  // Activation is always disabled entirely for clusters using VDS as their
  // engine, regardless of the value of this setting.
  private final BooleanNode disable_bucket_activation;
  // Maximum clock skew across nodes in the cluster, in whole seconds.
  // Used to prevent timestamp collisions during distributor bucket ownership
  // transfers.
  // Zero means this mechanism is disabled.
  private final IntegerNode max_cluster_clock_skew_sec;
  // Number of seconds that scheduling of new merge operations should be inhibited
  // towards a node if it has indicated that its merge queues are full or it is
  // suffering from resource exhaustion.
  private final IntegerNode inhibit_merge_sending_on_busy_node_duration_sec;
  // If set, enables potentially stale reads during cluster state transitions where
  // buckets change ownership. This also implicitly enables support for two-phase
  // cluster state transitions on the distributor.
  // For this option to take effect, the cluster controller must also have two-phase
  // states enabled.
  private final BooleanNode allow_stale_reads_during_cluster_state_transitions;
  // If greater than zero, injects a thread sleep into certain parts of the bucket
  // processing logic. This allows for easier testing of racing edge cases where the
  // main distributor thread is CPU-blocked processing large amounts of buckets, but
  // without actually needing to use a lot of buckets in the test itself.
  // Setting any of these values only makes sense for testing!
  private final IntegerNode simulated_db_pruning_latency_msec;
  private final IntegerNode simulated_db_merging_latency_msec;
  // If set, no merge operations may be generated for any reason by a distributor.
  // This is ONLY intended for system testing of certain transient edge cases and
  // MUST NOT be set to true in a production environment.
  private final BooleanNode merge_operations_disabled;
  // If set, Get operations that are initiated by the client (i.e. _not_ Get operations
  // that are initiated by the distributor) will be forwarded to the backend with
  // a flag signalling that weak read consistency may be used. This allows the
  // backend to minimize internal locking. The downside is that it's not guaranteed
  // to observe the most recent writes to the document, nor to observe an atomically
  // consistent view of fields across document versions.
  // This is mostly useful in a system that is effectively read-only.
  private final BooleanNode use_weak_internal_read_consistency_for_client_gets;
  // If a distributor main thread tick is constantly processing requests or responses
  // originating from other nodes, setting this value above zero will prevent implicit
  // maintenance scans from being done as part of the tick for up to N rounds of ticking.
  // This is to reduce the amount of CPU spent on ideal state calculations and bucket DB
  // accesses when the distributor is heavily loaded with feed operations.
  private final IntegerNode max_consecutively_inhibited_maintenance_ticks;
  // If set, activation of bucket replicas is limited to only those replicas that have
  // bucket info consistent with a majority of the other replicas for that bucket.
  // Multiple active replicas is only a feature that is enabled for grouped clusters,
  // and this feature is intended to prevent nodes in stale groups (whose buckets are
  // likely to be out of sync) from serving query traffic until they have gotten back
  // into sync.
  // Up to the given number of groups can have their replica activation inhibited
  // by this feature. If zero, the feature is functionally disabled.
  // If more groups are out of sync than the configured number N, the inhibited groups
  // will be the N first groups present in the distribution config.
  // Note: this feature only kicks in if the number of groups in the cluster is greater
  // than 1.
  private final IntegerNode max_activation_inhibited_out_of_sync_groups;
  // Specifies the number of stripes over which a distributor internally distributes
  // its buckets and operation processing. Every stripe receives its own thread.
  // If <= 0, the number of stripes is inferred automatically based on the number of
  // CPU cores available. If > 0, the number of stripes is explicitly overridden.
  // Stripe counts must be a power of two.
  private final IntegerNode num_distributor_stripes;
  // If true, changes in the cluster where a subset of the nodes become unavailable or buckets
  // change ownership between distributors will trigger an explicit cancellation of all pending
  // requests partially or fully "invalidated" by such a change.
  private final BooleanNode enable_operation_cancellation;
  // Iff true there will be an 1-1 symmetry between the replicas chosen as feed targets
  // for Put operations and the replica selection logic for bucket activation. In particular,
  // the most preferred replica for feed will be the most preferred bucket for activation.
  // This helps ensure that new versions of documents are routed to replicas that are most
  // likely to reflect these changes as part of visible search results.
  private final BooleanNode symmetric_put_and_activate_replica_selection;
  // Iff set to a value > 0, will enforce a size check on Put and Update operations arriving
  // at the distributor, where over-sized messages will be explicitly rejected with a
  // non-retryable error code. Intended as a safety measure to prevent overly large documents
  // from being accepted into the cluster.
  //  
  // The message size is estimated based on the uncompressed on-wire serialized payload size,
  // so it's only a (possibly inaccurate) proxy for the actual impact the underlying document
  // operation will have on the backend. But it's a "free" heuristic since we already have
  // that information available from the RPC subsystem.
  //  
  // Any number <= 0 implicitly defaults to 2GiB (INT32_MAX), i.e. effectively unbounded.
  private final IntegerNode max_document_operation_message_size_bytes;
  // TODO GC very soon, it has no effect.
  private final IntegerNode priority_merge_out_of_sync_copies;
  // TODO GC as it has no effect
  private final BooleanNode use_btree_database;

  public StorDistributormanagerConfig(Builder builder) {
    this(builder, true);
  }

  private StorDistributormanagerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "stor-distributormanager must be initialized: " + builder.__uninitialized);

    splitsize = (builder.splitsize == null) ?
        new IntegerNode(16772216) : new IntegerNode(builder.splitsize);
    splitcount = (builder.splitcount == null) ?
        new IntegerNode(1024) : new IntegerNode(builder.splitcount);
    joinsize = (builder.joinsize == null) ?
        new IntegerNode(16000000) : new IntegerNode(builder.joinsize);
    joincount = (builder.joincount == null) ?
        new IntegerNode(512) : new IntegerNode(builder.joincount);
    minsplitcount = (builder.minsplitcount == null) ?
        new IntegerNode(16) : new IntegerNode(builder.minsplitcount);
    garbagecollection = new Garbagecollection(builder.garbagecollection, throwIfUninitialized);
    inlinebucketsplitting = (builder.inlinebucketsplitting == null) ?
        new BooleanNode(true) : new BooleanNode(builder.inlinebucketsplitting);
    maximum_nodes_per_merge = (builder.maximum_nodes_per_merge == null) ?
        new IntegerNode(16) : new IntegerNode(builder.maximum_nodes_per_merge);
    start_distributor_thread = (builder.start_distributor_thread == null) ?
        new BooleanNode(true) : new BooleanNode(builder.start_distributor_thread);
    enable_join_for_sibling_less_buckets = (builder.enable_join_for_sibling_less_buckets == null) ?
        new BooleanNode(false) : new BooleanNode(builder.enable_join_for_sibling_less_buckets);
    enable_inconsistent_join = (builder.enable_inconsistent_join == null) ?
        new BooleanNode(false) : new BooleanNode(builder.enable_inconsistent_join);
    minimum_replica_counting_mode = (builder.minimum_replica_counting_mode == null) ?
        new Minimum_replica_counting_mode(Minimum_replica_counting_mode.TRUSTED) : new Minimum_replica_counting_mode(builder.minimum_replica_counting_mode);
    disable_bucket_activation = (builder.disable_bucket_activation == null) ?
        new BooleanNode(false) : new BooleanNode(builder.disable_bucket_activation);
    max_cluster_clock_skew_sec = (builder.max_cluster_clock_skew_sec == null) ?
        new IntegerNode(1) : new IntegerNode(builder.max_cluster_clock_skew_sec);
    inhibit_merge_sending_on_busy_node_duration_sec = (builder.inhibit_merge_sending_on_busy_node_duration_sec == null) ?
        new IntegerNode(1) : new IntegerNode(builder.inhibit_merge_sending_on_busy_node_duration_sec);
    allow_stale_reads_during_cluster_state_transitions = (builder.allow_stale_reads_during_cluster_state_transitions == null) ?
        new BooleanNode(false) : new BooleanNode(builder.allow_stale_reads_during_cluster_state_transitions);
    simulated_db_pruning_latency_msec = (builder.simulated_db_pruning_latency_msec == null) ?
        new IntegerNode(0) : new IntegerNode(builder.simulated_db_pruning_latency_msec);
    simulated_db_merging_latency_msec = (builder.simulated_db_merging_latency_msec == null) ?
        new IntegerNode(0) : new IntegerNode(builder.simulated_db_merging_latency_msec);
    merge_operations_disabled = (builder.merge_operations_disabled == null) ?
        new BooleanNode(false) : new BooleanNode(builder.merge_operations_disabled);
    use_weak_internal_read_consistency_for_client_gets = (builder.use_weak_internal_read_consistency_for_client_gets == null) ?
        new BooleanNode(false) : new BooleanNode(builder.use_weak_internal_read_consistency_for_client_gets);
    max_consecutively_inhibited_maintenance_ticks = (builder.max_consecutively_inhibited_maintenance_ticks == null) ?
        new IntegerNode(20) : new IntegerNode(builder.max_consecutively_inhibited_maintenance_ticks);
    max_activation_inhibited_out_of_sync_groups = (builder.max_activation_inhibited_out_of_sync_groups == null) ?
        new IntegerNode(0) : new IntegerNode(builder.max_activation_inhibited_out_of_sync_groups);
    num_distributor_stripes = (builder.num_distributor_stripes == null) ?
        new IntegerNode(0) : new IntegerNode(builder.num_distributor_stripes);
    enable_operation_cancellation = (builder.enable_operation_cancellation == null) ?
        new BooleanNode(false) : new BooleanNode(builder.enable_operation_cancellation);
    symmetric_put_and_activate_replica_selection = (builder.symmetric_put_and_activate_replica_selection == null) ?
        new BooleanNode(false) : new BooleanNode(builder.symmetric_put_and_activate_replica_selection);
    max_document_operation_message_size_bytes = (builder.max_document_operation_message_size_bytes == null) ?
        new IntegerNode(134217728) : new IntegerNode(builder.max_document_operation_message_size_bytes);
    priority_merge_out_of_sync_copies = (builder.priority_merge_out_of_sync_copies == null) ?
        new IntegerNode(120) : new IntegerNode(builder.priority_merge_out_of_sync_copies);
    use_btree_database = (builder.use_btree_database == null) ?
        new BooleanNode(true) : new BooleanNode(builder.use_btree_database);
  }

  /**
   * @return stor-distributormanager.splitsize
   */
  public int splitsize() {
    return splitsize.value();
  }

  /**
   * @return stor-distributormanager.splitcount
   */
  public int splitcount() {
    return splitcount.value();
  }

  /**
   * @return stor-distributormanager.joinsize
   */
  public int joinsize() {
    return joinsize.value();
  }

  /**
   * @return stor-distributormanager.joincount
   */
  public int joincount() {
    return joincount.value();
  }

  /**
   * @return stor-distributormanager.minsplitcount
   */
  public int minsplitcount() {
    return minsplitcount.value();
  }

  /**
   * @return stor-distributormanager.garbagecollection
   */
  public Garbagecollection garbagecollection() {
    return garbagecollection;
  }

  /**
   * @return stor-distributormanager.inlinebucketsplitting
   */
  public boolean inlinebucketsplitting() {
    return inlinebucketsplitting.value();
  }

  /**
   * @return stor-distributormanager.maximum_nodes_per_merge
   */
  public int maximum_nodes_per_merge() {
    return maximum_nodes_per_merge.value();
  }

  /**
   * @return stor-distributormanager.start_distributor_thread
   */
  public boolean start_distributor_thread() {
    return start_distributor_thread.value();
  }

  /**
   * @return stor-distributormanager.enable_join_for_sibling_less_buckets
   */
  public boolean enable_join_for_sibling_less_buckets() {
    return enable_join_for_sibling_less_buckets.value();
  }

  /**
   * @return stor-distributormanager.enable_inconsistent_join
   */
  public boolean enable_inconsistent_join() {
    return enable_inconsistent_join.value();
  }

  /**
   * @return stor-distributormanager.minimum_replica_counting_mode
   */
  public Minimum_replica_counting_mode.Enum minimum_replica_counting_mode() {
    return minimum_replica_counting_mode.value();
  }

  /**
   * @return stor-distributormanager.disable_bucket_activation
   */
  public boolean disable_bucket_activation() {
    return disable_bucket_activation.value();
  }

  /**
   * @return stor-distributormanager.max_cluster_clock_skew_sec
   */
  public int max_cluster_clock_skew_sec() {
    return max_cluster_clock_skew_sec.value();
  }

  /**
   * @return stor-distributormanager.inhibit_merge_sending_on_busy_node_duration_sec
   */
  public int inhibit_merge_sending_on_busy_node_duration_sec() {
    return inhibit_merge_sending_on_busy_node_duration_sec.value();
  }

  /**
   * @return stor-distributormanager.allow_stale_reads_during_cluster_state_transitions
   */
  public boolean allow_stale_reads_during_cluster_state_transitions() {
    return allow_stale_reads_during_cluster_state_transitions.value();
  }

  /**
   * @return stor-distributormanager.simulated_db_pruning_latency_msec
   */
  public int simulated_db_pruning_latency_msec() {
    return simulated_db_pruning_latency_msec.value();
  }

  /**
   * @return stor-distributormanager.simulated_db_merging_latency_msec
   */
  public int simulated_db_merging_latency_msec() {
    return simulated_db_merging_latency_msec.value();
  }

  /**
   * @return stor-distributormanager.merge_operations_disabled
   */
  public boolean merge_operations_disabled() {
    return merge_operations_disabled.value();
  }

  /**
   * @return stor-distributormanager.use_weak_internal_read_consistency_for_client_gets
   */
  public boolean use_weak_internal_read_consistency_for_client_gets() {
    return use_weak_internal_read_consistency_for_client_gets.value();
  }

  /**
   * @return stor-distributormanager.max_consecutively_inhibited_maintenance_ticks
   */
  public int max_consecutively_inhibited_maintenance_ticks() {
    return max_consecutively_inhibited_maintenance_ticks.value();
  }

  /**
   * @return stor-distributormanager.max_activation_inhibited_out_of_sync_groups
   */
  public int max_activation_inhibited_out_of_sync_groups() {
    return max_activation_inhibited_out_of_sync_groups.value();
  }

  /**
   * @return stor-distributormanager.num_distributor_stripes
   */
  public int num_distributor_stripes() {
    return num_distributor_stripes.value();
  }

  /**
   * @return stor-distributormanager.enable_operation_cancellation
   */
  public boolean enable_operation_cancellation() {
    return enable_operation_cancellation.value();
  }

  /**
   * @return stor-distributormanager.symmetric_put_and_activate_replica_selection
   */
  public boolean symmetric_put_and_activate_replica_selection() {
    return symmetric_put_and_activate_replica_selection.value();
  }

  /**
   * @return stor-distributormanager.max_document_operation_message_size_bytes
   */
  public int max_document_operation_message_size_bytes() {
    return max_document_operation_message_size_bytes.value();
  }

  /**
   * @return stor-distributormanager.priority_merge_out_of_sync_copies
   */
  public int priority_merge_out_of_sync_copies() {
    return priority_merge_out_of_sync_copies.value();
  }

  /**
   * @return stor-distributormanager.use_btree_database
   */
  public boolean use_btree_database() {
    return use_btree_database.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(StorDistributormanagerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("stor-distributormanager");
      changes.compare(this.start_distributor_thread, newConfig.start_distributor_thread, "start_distributor_thread", "For internal in process debugging, it may be useful to not start the\ndistributor thread to be able to call tick() manually and run single threaded");
      changes.compare(this.num_distributor_stripes, newConfig.num_distributor_stripes, "num_distributor_stripes", "Specifies the number of stripes over which a distributor internally distributes\nits buckets and operation processing. Every stripe receives its own thread.\nIf <= 0, the number of stripes is inferred automatically based on the number of\nCPU cores available. If > 0, the number of stripes is explicitly overridden.\nStripe counts must be a power of two.");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }

  /**
   * This class represents stor-distributormanager.garbagecollection
   */
  public final static class Garbagecollection extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private String selectiontoremove = null;
      private Integer interval = null;

      public Builder() { }

      public Builder(Garbagecollection config) {
        selectiontoremove(config.selectiontoremove());
        interval(config.interval());
      }

      private Builder override(Builder __superior) {
        if (__superior.selectiontoremove != null)
          selectiontoremove(__superior.selectiontoremove);
        if (__superior.interval != null)
          interval(__superior.interval);
        return this;
      }

      public Builder selectiontoremove(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        selectiontoremove = __value;
        return this;
      }


      public Builder interval(int __value) {
        interval = __value;
        return this;
      }

      private Builder interval(String __value) {
        return interval(Integer.valueOf(__value));
      }

      public Garbagecollection build() {
        return new Garbagecollection(this);
      }

    }

    // If non-empty, continuously delete all the documents matching this selection.
    private final StringNode selectiontoremove;
    // The interval with which each bucket is purged using the selection above.
    // If 0, no garbage collection is done.
    private final IntegerNode interval;

    public Garbagecollection(Builder builder) {
      this(builder, true);
    }

    private Garbagecollection(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "stor-distributormanager.garbagecollection must be initialized: " + builder.__uninitialized);

      selectiontoremove = (builder.selectiontoremove == null) ?
          new StringNode("") : new StringNode(builder.selectiontoremove);
      interval = (builder.interval == null) ?
          new IntegerNode(0) : new IntegerNode(builder.interval);
    }

    /**
     * @return stor-distributormanager.garbagecollection.selectiontoremove
     */
    public String selectiontoremove() {
      return selectiontoremove.value();
    }

    /**
     * @return stor-distributormanager.garbagecollection.interval
     */
    public int interval() {
      return interval.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Garbagecollection newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("garbagecollection");
      return changes;
    }
  }

  /**
   * This class represents stor-distributormanager.minimum_replica_counting_mode
   * 
   * For each available node, the distributor will report back to the cluster
   * controller a value which indicates the minimum replication factor for any
   * bucket contained on said node. This config exposes a way to alter how this
   * replication factor is computed.
   *  
   * Valid enum values and their semantics:
   *  
   * TRUSTED - only trusted replicas are counted.
   * ANY - any replica present is counted. This may return an overly optimistic
   * view of the system. E.g. if there are 3 replicas, 1 having 1000 docs
   * and 2 having 1 doc, all being out of sync, counting with ANY will still
   * treat this as a minimum replication factor of 3. Conversely, with
   * TRUSTED such a bucket would most likely have a factor of 0 (or 1 iff
   * the trusted status for the replica with 1000 docs is known).
   */
  public final static class Minimum_replica_counting_mode extends EnumNode<Minimum_replica_counting_mode.Enum> {

    public Minimum_replica_counting_mode(){
      this.value = null;
    }

    public Minimum_replica_counting_mode(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {TRUSTED, ANY}
    public final static Enum TRUSTED = Enum.TRUSTED;
    public final static Enum ANY = Enum.ANY;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

}
