// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of stor-communicationmanager
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class StorCommunicationmanagerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "10b9c60647237b2c3c3905fd45cbae83";
  public final static String CONFIG_DEF_NAME = "stor-communicationmanager";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content.core",
    "mbusport int default=-1 restart",
    "rpcport int default=6000 restart",
    "mbus_distributor_node_max_pending_count int default=5000",
    "mbus_content_node_max_pending_count int default=0",
    "mbus_distributor_node_max_pending_size int default=0",
    "mbus_content_node_max_pending_size int default=0",
    "mbus.compress.limit int default=1024 restart",
    "mbus.compress.level int default=3 restart",
    "mbus.compress.type enum {NONE, LZ4, ZSTD} default=LZ4 restart",
    "mbus.rpctargetcache.ttl double default = 600 restart",
    "mbus.num_rpc_targets int default=2 restart",
    "mbus.tcp_no_delay bool default=true restart",
    "mbus.num_network_threads int default=1 restart",
    "mbus.events_before_wakeup int default=1 restart",
    "rpc.num_network_threads int default=2 restart",
    "rpc.events_before_wakeup int default=1 restart",
    "rpc.num_targets_per_node int default=2 restart",
    "rpc.compress.limit int default=1024 restart",
    "rpc.compress.level int default=3 restart",
    "rpc.compress.type enum {NONE, LZ4, ZSTD} default=LZ4 restart"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer mbusport = null;
    private Integer rpcport = null;
    private Integer mbus_distributor_node_max_pending_count = null;
    private Integer mbus_content_node_max_pending_count = null;
    private Integer mbus_distributor_node_max_pending_size = null;
    private Integer mbus_content_node_max_pending_size = null;
    public Mbus.Builder mbus = new Mbus.Builder();
    public Rpc.Builder rpc = new Rpc.Builder();

    public Builder() { }

    public Builder(StorCommunicationmanagerConfig config) {
      mbusport(config.mbusport());
      rpcport(config.rpcport());
      mbus_distributor_node_max_pending_count(config.mbus_distributor_node_max_pending_count());
      mbus_content_node_max_pending_count(config.mbus_content_node_max_pending_count());
      mbus_distributor_node_max_pending_size(config.mbus_distributor_node_max_pending_size());
      mbus_content_node_max_pending_size(config.mbus_content_node_max_pending_size());
      mbus(new Mbus.Builder(config.mbus()));
      rpc(new Rpc.Builder(config.rpc()));
    }

    private Builder override(Builder __superior) {
      if (__superior.mbusport != null)
        mbusport(__superior.mbusport);
      if (__superior.rpcport != null)
        rpcport(__superior.rpcport);
      if (__superior.mbus_distributor_node_max_pending_count != null)
        mbus_distributor_node_max_pending_count(__superior.mbus_distributor_node_max_pending_count);
      if (__superior.mbus_content_node_max_pending_count != null)
        mbus_content_node_max_pending_count(__superior.mbus_content_node_max_pending_count);
      if (__superior.mbus_distributor_node_max_pending_size != null)
        mbus_distributor_node_max_pending_size(__superior.mbus_distributor_node_max_pending_size);
      if (__superior.mbus_content_node_max_pending_size != null)
        mbus_content_node_max_pending_size(__superior.mbus_content_node_max_pending_size);
      mbus(mbus.override(__superior.mbus));
      rpc(rpc.override(__superior.rpc));
      return this;
    }

    public Builder mbusport(int __value) {
      mbusport = __value;
      return this;
    }

    private Builder mbusport(String __value) {
      return mbusport(Integer.valueOf(__value));
    }

    public Builder rpcport(int __value) {
      rpcport = __value;
      return this;
    }

    private Builder rpcport(String __value) {
      return rpcport(Integer.valueOf(__value));
    }

    public Builder mbus_distributor_node_max_pending_count(int __value) {
      mbus_distributor_node_max_pending_count = __value;
      return this;
    }

    private Builder mbus_distributor_node_max_pending_count(String __value) {
      return mbus_distributor_node_max_pending_count(Integer.valueOf(__value));
    }

    public Builder mbus_content_node_max_pending_count(int __value) {
      mbus_content_node_max_pending_count = __value;
      return this;
    }

    private Builder mbus_content_node_max_pending_count(String __value) {
      return mbus_content_node_max_pending_count(Integer.valueOf(__value));
    }

    public Builder mbus_distributor_node_max_pending_size(int __value) {
      mbus_distributor_node_max_pending_size = __value;
      return this;
    }

    private Builder mbus_distributor_node_max_pending_size(String __value) {
      return mbus_distributor_node_max_pending_size(Integer.valueOf(__value));
    }

    public Builder mbus_content_node_max_pending_size(int __value) {
      mbus_content_node_max_pending_size = __value;
      return this;
    }

    private Builder mbus_content_node_max_pending_size(String __value) {
      return mbus_content_node_max_pending_size(Integer.valueOf(__value));
    }

    public Builder mbus(Mbus.Builder __builder) {
      mbus = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder mbus(java.util.function.Consumer<Mbus.Builder> __func) {
      Mbus.Builder __inner = new Mbus.Builder();
      __func.accept(__inner);
      mbus = __inner;
      return this;
    }

    public Builder rpc(Rpc.Builder __builder) {
      rpc = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder rpc(java.util.function.Consumer<Rpc.Builder> __func) {
      Rpc.Builder __inner = new Rpc.Builder();
      __func.accept(__inner);
      rpc = __inner;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public StorCommunicationmanagerConfig build() {
      return new StorCommunicationmanagerConfig(this);
    }

  }

  private final IntegerNode mbusport;
  private final IntegerNode rpcport;
  // Limits for max pending concurrent number of operations towards a node before
  // MessageBus starts busy-bouncing messages. Distributor and content nodes are
  // treated separately. 0 means no limit.
  private final IntegerNode mbus_distributor_node_max_pending_count;
  private final IntegerNode mbus_content_node_max_pending_count;
  // Limits for max total amount of memory (in bytes) used by operations towards
  // a node before MessageBus starts busy-bouncing messages. Distributor and
  // content nodes are treated separately. 0 means no limit.
  private final IntegerNode mbus_distributor_node_max_pending_size;
  private final IntegerNode mbus_content_node_max_pending_size;
  private final Mbus mbus;
  private final Rpc rpc;

  public StorCommunicationmanagerConfig(Builder builder) {
    this(builder, true);
  }

  private StorCommunicationmanagerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "stor-communicationmanager must be initialized: " + builder.__uninitialized);

    mbusport = (builder.mbusport == null) ?
        new IntegerNode(-1) : new IntegerNode(builder.mbusport);
    rpcport = (builder.rpcport == null) ?
        new IntegerNode(6000) : new IntegerNode(builder.rpcport);
    mbus_distributor_node_max_pending_count = (builder.mbus_distributor_node_max_pending_count == null) ?
        new IntegerNode(5000) : new IntegerNode(builder.mbus_distributor_node_max_pending_count);
    mbus_content_node_max_pending_count = (builder.mbus_content_node_max_pending_count == null) ?
        new IntegerNode(0) : new IntegerNode(builder.mbus_content_node_max_pending_count);
    mbus_distributor_node_max_pending_size = (builder.mbus_distributor_node_max_pending_size == null) ?
        new IntegerNode(0) : new IntegerNode(builder.mbus_distributor_node_max_pending_size);
    mbus_content_node_max_pending_size = (builder.mbus_content_node_max_pending_size == null) ?
        new IntegerNode(0) : new IntegerNode(builder.mbus_content_node_max_pending_size);
    mbus = new Mbus(builder.mbus, throwIfUninitialized);
    rpc = new Rpc(builder.rpc, throwIfUninitialized);
  }

  /**
   * @return stor-communicationmanager.mbusport
   */
  public int mbusport() {
    return mbusport.value();
  }

  /**
   * @return stor-communicationmanager.rpcport
   */
  public int rpcport() {
    return rpcport.value();
  }

  /**
   * @return stor-communicationmanager.mbus_distributor_node_max_pending_count
   */
  public int mbus_distributor_node_max_pending_count() {
    return mbus_distributor_node_max_pending_count.value();
  }

  /**
   * @return stor-communicationmanager.mbus_content_node_max_pending_count
   */
  public int mbus_content_node_max_pending_count() {
    return mbus_content_node_max_pending_count.value();
  }

  /**
   * @return stor-communicationmanager.mbus_distributor_node_max_pending_size
   */
  public int mbus_distributor_node_max_pending_size() {
    return mbus_distributor_node_max_pending_size.value();
  }

  /**
   * @return stor-communicationmanager.mbus_content_node_max_pending_size
   */
  public int mbus_content_node_max_pending_size() {
    return mbus_content_node_max_pending_size.value();
  }

  /**
   * @return stor-communicationmanager.mbus
   */
  public Mbus mbus() {
    return mbus;
  }

  /**
   * @return stor-communicationmanager.rpc
   */
  public Rpc rpc() {
    return rpc;
  }

  private ChangesRequiringRestart getChangesRequiringRestart(StorCommunicationmanagerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("stor-communicationmanager");
      changes.compare(this.mbusport, newConfig.mbusport, "mbusport", "");
      changes.compare(this.rpcport, newConfig.rpcport, "rpcport", "");
      changes.mergeChanges("mbus", this.mbus.getChangesRequiringRestart(newConfig.mbus));
      changes.mergeChanges("rpc", this.rpc.getChangesRequiringRestart(newConfig.rpc));
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }

  /**
   * This class represents stor-communicationmanager.mbus
   */
  public final static class Mbus extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Compress.Builder compress = new Compress.Builder();
      public Rpctargetcache.Builder rpctargetcache = new Rpctargetcache.Builder();
      private Integer num_rpc_targets = null;
      private Boolean tcp_no_delay = null;
      private Integer num_network_threads = null;
      private Integer events_before_wakeup = null;

      public Builder() { }

      public Builder(Mbus config) {
        compress(new Compress.Builder(config.compress()));
        rpctargetcache(new Rpctargetcache.Builder(config.rpctargetcache()));
        num_rpc_targets(config.num_rpc_targets());
        tcp_no_delay(config.tcp_no_delay());
        num_network_threads(config.num_network_threads());
        events_before_wakeup(config.events_before_wakeup());
      }

      private Builder override(Builder __superior) {
        compress(compress.override(__superior.compress));
        rpctargetcache(rpctargetcache.override(__superior.rpctargetcache));
        if (__superior.num_rpc_targets != null)
          num_rpc_targets(__superior.num_rpc_targets);
        if (__superior.tcp_no_delay != null)
          tcp_no_delay(__superior.tcp_no_delay);
        if (__superior.num_network_threads != null)
          num_network_threads(__superior.num_network_threads);
        if (__superior.events_before_wakeup != null)
          events_before_wakeup(__superior.events_before_wakeup);
        return this;
      }

      public Builder compress(Compress.Builder __builder) {
        compress = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder compress(java.util.function.Consumer<Compress.Builder> __func) {
        Compress.Builder __inner = new Compress.Builder();
        __func.accept(__inner);
        compress = __inner;
        return this;
      }

      public Builder rpctargetcache(Rpctargetcache.Builder __builder) {
        rpctargetcache = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder rpctargetcache(java.util.function.Consumer<Rpctargetcache.Builder> __func) {
        Rpctargetcache.Builder __inner = new Rpctargetcache.Builder();
        __func.accept(__inner);
        rpctargetcache = __inner;
        return this;
      }

      public Builder num_rpc_targets(int __value) {
        num_rpc_targets = __value;
        return this;
      }

      private Builder num_rpc_targets(String __value) {
        return num_rpc_targets(Integer.valueOf(__value));
      }

      public Builder tcp_no_delay(boolean __value) {
        tcp_no_delay = __value;
        return this;
      }

      private Builder tcp_no_delay(String __value) {
        return tcp_no_delay(Boolean.valueOf(__value));
      }

      public Builder num_network_threads(int __value) {
        num_network_threads = __value;
        return this;
      }

      private Builder num_network_threads(String __value) {
        return num_network_threads(Integer.valueOf(__value));
      }

      public Builder events_before_wakeup(int __value) {
        events_before_wakeup = __value;
        return this;
      }

      private Builder events_before_wakeup(String __value) {
        return events_before_wakeup(Integer.valueOf(__value));
      }

      public Mbus build() {
        return new Mbus(this);
      }

    }

    private final Compress compress;
    private final Rpctargetcache rpctargetcache;
    // Number of rpc targets per spec
    private final IntegerNode num_rpc_targets;
    // Use tcpNoDelay for mbus network writes
    private final BooleanNode tcp_no_delay;
    // Number of threads for network.
    private final IntegerNode num_network_threads;
    // The number of events in the queue of a network (FNET) thread before it is woken up.
    private final IntegerNode events_before_wakeup;

    public Mbus(Builder builder) {
      this(builder, true);
    }

    private Mbus(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "stor-communicationmanager.mbus must be initialized: " + builder.__uninitialized);

      compress = new Compress(builder.compress, throwIfUninitialized);
      rpctargetcache = new Rpctargetcache(builder.rpctargetcache, throwIfUninitialized);
      num_rpc_targets = (builder.num_rpc_targets == null) ?
          new IntegerNode(2) : new IntegerNode(builder.num_rpc_targets);
      tcp_no_delay = (builder.tcp_no_delay == null) ?
          new BooleanNode(true) : new BooleanNode(builder.tcp_no_delay);
      num_network_threads = (builder.num_network_threads == null) ?
          new IntegerNode(1) : new IntegerNode(builder.num_network_threads);
      events_before_wakeup = (builder.events_before_wakeup == null) ?
          new IntegerNode(1) : new IntegerNode(builder.events_before_wakeup);
    }

    /**
     * @return stor-communicationmanager.mbus.compress
     */
    public Compress compress() {
      return compress;
    }

    /**
     * @return stor-communicationmanager.mbus.rpctargetcache
     */
    public Rpctargetcache rpctargetcache() {
      return rpctargetcache;
    }

    /**
     * @return stor-communicationmanager.mbus.num_rpc_targets
     */
    public int num_rpc_targets() {
      return num_rpc_targets.value();
    }

    /**
     * @return stor-communicationmanager.mbus.tcp_no_delay
     */
    public boolean tcp_no_delay() {
      return tcp_no_delay.value();
    }

    /**
     * @return stor-communicationmanager.mbus.num_network_threads
     */
    public int num_network_threads() {
      return num_network_threads.value();
    }

    /**
     * @return stor-communicationmanager.mbus.events_before_wakeup
     */
    public int events_before_wakeup() {
      return events_before_wakeup.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Mbus newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("mbus");
        changes.mergeChanges("compress", this.compress.getChangesRequiringRestart(newConfig.compress));
        changes.mergeChanges("rpctargetcache", this.rpctargetcache.getChangesRequiringRestart(newConfig.rpctargetcache));
        changes.compare(this.num_rpc_targets, newConfig.num_rpc_targets, "num_rpc_targets", "Number of rpc targets per spec");
        changes.compare(this.tcp_no_delay, newConfig.tcp_no_delay, "tcp_no_delay", "Use tcpNoDelay for mbus network writes");
        changes.compare(this.num_network_threads, newConfig.num_network_threads, "num_network_threads", "Number of threads for network.");
        changes.compare(this.events_before_wakeup, newConfig.events_before_wakeup, "events_before_wakeup", "The number of events in the queue of a network (FNET) thread before it is woken up.");
      return changes;
    }

    /**
     * This class represents stor-communicationmanager.mbus.compress
     */
    public final static class Compress extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Integer limit = null;
        private Integer level = null;
        private Type.Enum type = null;

        public Builder() { }

        public Builder(Compress config) {
          limit(config.limit());
          level(config.level());
          type(config.type());
        }

        private Builder override(Builder __superior) {
          if (__superior.limit != null)
            limit(__superior.limit);
          if (__superior.level != null)
            level(__superior.level);
          if (__superior.type != null)
            type(__superior.type);
          return this;
        }

        public Builder limit(int __value) {
          limit = __value;
          return this;
        }

        private Builder limit(String __value) {
          return limit(Integer.valueOf(__value));
        }

        public Builder level(int __value) {
          level = __value;
          return this;
        }

        private Builder level(String __value) {
          return level(Integer.valueOf(__value));
        }

        public Builder type(Type.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          type = __value;
          return this;
        }

        private Builder type(String __value) {
          return type(Type.Enum.valueOf(__value));
        }

        public Compress build() {
          return new Compress(this);
        }

      }

      // Minimum size of packets to compress (0 means no compression)
      // TODO Common compression config for mbus and rpc, and consider ZSTD as default
      private final IntegerNode limit;
      // Compression level for packets
      private final IntegerNode level;
      // Compression type for packets.
      private final Type type;

      public Compress(Builder builder) {
        this(builder, true);
      }

      private Compress(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "stor-communicationmanager.mbus.compress must be initialized: " + builder.__uninitialized);

        limit = (builder.limit == null) ?
            new IntegerNode(1024) : new IntegerNode(builder.limit);
        level = (builder.level == null) ?
            new IntegerNode(3) : new IntegerNode(builder.level);
        type = (builder.type == null) ?
            new Type(Type.LZ4) : new Type(builder.type);
      }

      /**
       * @return stor-communicationmanager.mbus.compress.limit
       */
      public int limit() {
        return limit.value();
      }

      /**
       * @return stor-communicationmanager.mbus.compress.level
       */
      public int level() {
        return level.value();
      }

      /**
       * @return stor-communicationmanager.mbus.compress.type
       */
      public Type.Enum type() {
        return type.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Compress newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("compress");
          changes.compare(this.limit, newConfig.limit, "limit", "Minimum size of packets to compress (0 means no compression)\nTODO Common compression config for mbus and rpc, and consider ZSTD as default");
          changes.compare(this.level, newConfig.level, "level", "Compression level for packets");
          changes.compare(this.type, newConfig.type, "type", "Compression type for packets.");
        return changes;
      }

      /**
       * This class represents stor-communicationmanager.mbus.compress.type
       * 
       * Compression type for packets.
       */
      public final static class Type extends EnumNode<Type.Enum> {

        public Type(){
          this.value = null;
        }

        public Type(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {NONE, LZ4, ZSTD}
        public final static Enum NONE = Enum.NONE;
        public final static Enum LZ4 = Enum.LZ4;
        public final static Enum ZSTD = Enum.ZSTD;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }
    }

    /**
     * This class represents stor-communicationmanager.mbus.rpctargetcache
     */
    public final static class Rpctargetcache extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Double ttl = null;

        public Builder() { }

        public Builder(Rpctargetcache config) {
          ttl(config.ttl());
        }

        private Builder override(Builder __superior) {
          if (__superior.ttl != null)
            ttl(__superior.ttl);
          return this;
        }

        public Builder ttl(double __value) {
          ttl = __value;
          return this;
        }

        private Builder ttl(String __value) {
          return ttl(Double.valueOf(__value));
        }

        public Rpctargetcache build() {
          return new Rpctargetcache(this);
        }

      }

      // TTL for rpc target cache
      private final DoubleNode ttl;

      public Rpctargetcache(Builder builder) {
        this(builder, true);
      }

      private Rpctargetcache(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "stor-communicationmanager.mbus.rpctargetcache must be initialized: " + builder.__uninitialized);

        ttl = (builder.ttl == null) ?
            new DoubleNode(600D) : new DoubleNode(builder.ttl);
      }

      /**
       * @return stor-communicationmanager.mbus.rpctargetcache.ttl
       */
      public double ttl() {
        return ttl.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Rpctargetcache newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("rpctargetcache");
          changes.compare(this.ttl, newConfig.ttl, "ttl", "TTL for rpc target cache");
        return changes;
      }
    }
  }

  /**
   * This class represents stor-communicationmanager.rpc
   */
  public final static class Rpc extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Integer num_network_threads = null;
      private Integer events_before_wakeup = null;
      private Integer num_targets_per_node = null;
      public Compress.Builder compress = new Compress.Builder();

      public Builder() { }

      public Builder(Rpc config) {
        num_network_threads(config.num_network_threads());
        events_before_wakeup(config.events_before_wakeup());
        num_targets_per_node(config.num_targets_per_node());
        compress(new Compress.Builder(config.compress()));
      }

      private Builder override(Builder __superior) {
        if (__superior.num_network_threads != null)
          num_network_threads(__superior.num_network_threads);
        if (__superior.events_before_wakeup != null)
          events_before_wakeup(__superior.events_before_wakeup);
        if (__superior.num_targets_per_node != null)
          num_targets_per_node(__superior.num_targets_per_node);
        compress(compress.override(__superior.compress));
        return this;
      }

      public Builder num_network_threads(int __value) {
        num_network_threads = __value;
        return this;
      }

      private Builder num_network_threads(String __value) {
        return num_network_threads(Integer.valueOf(__value));
      }

      public Builder events_before_wakeup(int __value) {
        events_before_wakeup = __value;
        return this;
      }

      private Builder events_before_wakeup(String __value) {
        return events_before_wakeup(Integer.valueOf(__value));
      }

      public Builder num_targets_per_node(int __value) {
        num_targets_per_node = __value;
        return this;
      }

      private Builder num_targets_per_node(String __value) {
        return num_targets_per_node(Integer.valueOf(__value));
      }

      public Builder compress(Compress.Builder __builder) {
        compress = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder compress(java.util.function.Consumer<Compress.Builder> __func) {
        Compress.Builder __inner = new Compress.Builder();
        __func.accept(__inner);
        compress = __inner;
        return this;
      }

      public Rpc build() {
        return new Rpc(this);
      }

    }

    // The number of network (FNET) threads used by the shared rpc resource.
    private final IntegerNode num_network_threads;
    // The number of events in the queue of a network (FNET) thread before it is woken up.
    private final IntegerNode events_before_wakeup;
    // The number of (FNET) RPC targets to use per node in the cluster.
    //  
    // The bucket id associated with a message is used to select the RPC target.
    // This ensures the same RPC target is used for all messages to the same bucket to the same node,
    // and the RPC target itself handles sequencing of these messages.
    // NB !! It is vital that this number is kept in sync with stor-filestor:num_network_threads.
    // Only skilled vespa core developers should touch this.
    private final IntegerNode num_targets_per_node;
    private final Compress compress;

    public Rpc(Builder builder) {
      this(builder, true);
    }

    private Rpc(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "stor-communicationmanager.rpc must be initialized: " + builder.__uninitialized);

      num_network_threads = (builder.num_network_threads == null) ?
          new IntegerNode(2) : new IntegerNode(builder.num_network_threads);
      events_before_wakeup = (builder.events_before_wakeup == null) ?
          new IntegerNode(1) : new IntegerNode(builder.events_before_wakeup);
      num_targets_per_node = (builder.num_targets_per_node == null) ?
          new IntegerNode(2) : new IntegerNode(builder.num_targets_per_node);
      compress = new Compress(builder.compress, throwIfUninitialized);
    }

    /**
     * @return stor-communicationmanager.rpc.num_network_threads
     */
    public int num_network_threads() {
      return num_network_threads.value();
    }

    /**
     * @return stor-communicationmanager.rpc.events_before_wakeup
     */
    public int events_before_wakeup() {
      return events_before_wakeup.value();
    }

    /**
     * @return stor-communicationmanager.rpc.num_targets_per_node
     */
    public int num_targets_per_node() {
      return num_targets_per_node.value();
    }

    /**
     * @return stor-communicationmanager.rpc.compress
     */
    public Compress compress() {
      return compress;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Rpc newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("rpc");
        changes.compare(this.num_network_threads, newConfig.num_network_threads, "num_network_threads", "The number of network (FNET) threads used by the shared rpc resource.");
        changes.compare(this.events_before_wakeup, newConfig.events_before_wakeup, "events_before_wakeup", "The number of events in the queue of a network (FNET) thread before it is woken up.");
        changes.compare(this.num_targets_per_node, newConfig.num_targets_per_node, "num_targets_per_node", "The number of (FNET) RPC targets to use per node in the cluster.\n \nThe bucket id associated with a message is used to select the RPC target.\nThis ensures the same RPC target is used for all messages to the same bucket to the same node,\nand the RPC target itself handles sequencing of these messages.\nNB !! It is vital that this number is kept in sync with stor-filestor:num_network_threads.\nOnly skilled vespa core developers should touch this.");
        changes.mergeChanges("compress", this.compress.getChangesRequiringRestart(newConfig.compress));
      return changes;
    }

    /**
     * This class represents stor-communicationmanager.rpc.compress
     */
    public final static class Compress extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Integer limit = null;
        private Integer level = null;
        private Type.Enum type = null;

        public Builder() { }

        public Builder(Compress config) {
          limit(config.limit());
          level(config.level());
          type(config.type());
        }

        private Builder override(Builder __superior) {
          if (__superior.limit != null)
            limit(__superior.limit);
          if (__superior.level != null)
            level(__superior.level);
          if (__superior.type != null)
            type(__superior.type);
          return this;
        }

        public Builder limit(int __value) {
          limit = __value;
          return this;
        }

        private Builder limit(String __value) {
          return limit(Integer.valueOf(__value));
        }

        public Builder level(int __value) {
          level = __value;
          return this;
        }

        private Builder level(String __value) {
          return level(Integer.valueOf(__value));
        }

        public Builder type(Type.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          type = __value;
          return this;
        }

        private Builder type(String __value) {
          return type(Type.Enum.valueOf(__value));
        }

        public Compress build() {
          return new Compress(this);
        }

      }

      // Minimum size of packets to compress (0 means no compression)
      private final IntegerNode limit;
      // Compression level for packets
      private final IntegerNode level;
      // Compression type for packets.
      private final Type type;

      public Compress(Builder builder) {
        this(builder, true);
      }

      private Compress(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "stor-communicationmanager.rpc.compress must be initialized: " + builder.__uninitialized);

        limit = (builder.limit == null) ?
            new IntegerNode(1024) : new IntegerNode(builder.limit);
        level = (builder.level == null) ?
            new IntegerNode(3) : new IntegerNode(builder.level);
        type = (builder.type == null) ?
            new Type(Type.LZ4) : new Type(builder.type);
      }

      /**
       * @return stor-communicationmanager.rpc.compress.limit
       */
      public int limit() {
        return limit.value();
      }

      /**
       * @return stor-communicationmanager.rpc.compress.level
       */
      public int level() {
        return level.value();
      }

      /**
       * @return stor-communicationmanager.rpc.compress.type
       */
      public Type.Enum type() {
        return type.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Compress newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("compress");
          changes.compare(this.limit, newConfig.limit, "limit", "Minimum size of packets to compress (0 means no compression)");
          changes.compare(this.level, newConfig.level, "level", "Compression level for packets");
          changes.compare(this.type, newConfig.type, "type", "Compression type for packets.");
        return changes;
      }

      /**
       * This class represents stor-communicationmanager.rpc.compress.type
       * 
       * Compression type for packets.
       */
      public final static class Type extends EnumNode<Type.Enum> {

        public Type(){
          this.value = null;
        }

        public Type(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {NONE, LZ4, ZSTD}
        public final static Enum NONE = Enum.NONE;
        public final static Enum LZ4 = Enum.LZ4;
        public final static Enum ZSTD = Enum.ZSTD;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }
    }
  }

}
