// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of stor-bouncer
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class StorBouncerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "d0a19f7c56d6355f3f629baa35d46fdb";
  public final static String CONFIG_DEF_NAME = "stor-bouncer";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content.core",
    "max_clock_skew_seconds int default=5"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer max_clock_skew_seconds = null;

    public Builder() { }

    public Builder(StorBouncerConfig config) {
      max_clock_skew_seconds(config.max_clock_skew_seconds());
    }

    private Builder override(Builder __superior) {
      if (__superior.max_clock_skew_seconds != null)
        max_clock_skew_seconds(__superior.max_clock_skew_seconds);
      return this;
    }

    public Builder max_clock_skew_seconds(int __value) {
      max_clock_skew_seconds = __value;
      return this;
    }

    private Builder max_clock_skew_seconds(String __value) {
      return max_clock_skew_seconds(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public StorBouncerConfig build() {
      return new StorBouncerConfig(this);
    }

  }

  // The maximum clock skew allowed in the system. Any messages received
  // that have a timestamp longer in the future than this will be failed.
  private final IntegerNode max_clock_skew_seconds;

  public StorBouncerConfig(Builder builder) {
    this(builder, true);
  }

  private StorBouncerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "stor-bouncer must be initialized: " + builder.__uninitialized);

    max_clock_skew_seconds = (builder.max_clock_skew_seconds == null) ?
        new IntegerNode(5) : new IntegerNode(builder.max_clock_skew_seconds);
  }

  /**
   * @return stor-bouncer.max_clock_skew_seconds
   */
  public int max_clock_skew_seconds() {
    return max_clock_skew_seconds.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(StorBouncerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("stor-bouncer");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
