// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of rpc-provider
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class RpcProviderConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "e0c721199ca1c8a9aef454289df8eab2";
  public final static String CONFIG_DEF_NAME = "rpc-provider";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content.core",
    "connectspec string default=\"tcp/localhost:17777\" restart"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String connectspec = null;

    public Builder() { }

    public Builder(RpcProviderConfig config) {
      connectspec(config.connectspec());
    }

    private Builder override(Builder __superior) {
      if (__superior.connectspec != null)
        connectspec(__superior.connectspec);
      return this;
    }

    public Builder connectspec(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      connectspec = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public RpcProviderConfig build() {
      return new RpcProviderConfig(this);
    }

  }

  private final StringNode connectspec;

  public RpcProviderConfig(Builder builder) {
    this(builder, true);
  }

  private RpcProviderConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "rpc-provider must be initialized: " + builder.__uninitialized);

    connectspec = (builder.connectspec == null) ?
        new StringNode("tcp/localhost:17777") : new StringNode(builder.connectspec);
  }

  /**
   * @return rpc-provider.connectspec
   */
  public String connectspec() {
    return connectspec.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(RpcProviderConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("rpc-provider");
      changes.compare(this.connectspec, newConfig.connectspec, "connectspec", "");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }


}
