/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.KeyStoreBuilder;
import com.yahoo.security.KeyStoreType;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;

public class KeyManagerUtils {
    public static X509ExtendedKeyManager createDefaultX509KeyManager(KeyStore keystore, char[] password) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keystore, password);
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            return Arrays.stream(keyManagers).filter(manager -> manager instanceof X509ExtendedKeyManager).map(X509ExtendedKeyManager.class::cast).findFirst().orElseThrow(() -> new RuntimeException("No X509ExtendedKeyManager in " + String.valueOf(List.of(keyManagers))));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static X509ExtendedKeyManager createDefaultX509KeyManager(PrivateKey privateKey, List<X509Certificate> certificateChain) {
        KeyStore keystore = KeyStoreBuilder.withType(KeyStoreType.PKCS12).withKeyEntry("default", privateKey, certificateChain).build();
        return KeyManagerUtils.createDefaultX509KeyManager(keystore, new char[0]);
    }

    public static X509ExtendedKeyManager createDefaultX509KeyManager() {
        return KeyManagerUtils.createDefaultX509KeyManager(null, new char[0]);
    }
}

