/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.SubjectAlternativeName;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class Pkcs10Csr {
    private final PKCS10CertificationRequest csr;

    Pkcs10Csr(PKCS10CertificationRequest csr) {
        this.csr = csr;
    }

    PKCS10CertificationRequest getBcCsr() {
        return this.csr;
    }

    public X500Principal getSubject() {
        return new X500Principal(this.csr.getSubject().toString());
    }

    public List<SubjectAlternativeName> getSubjectAlternativeNames() {
        return this.getExtensions().map(extensions -> GeneralNames.fromExtensions((Extensions)extensions, (ASN1ObjectIdentifier)Extension.subjectAlternativeName)).map(SubjectAlternativeName::fromGeneralNames).orElse(List.of());
    }

    public Optional<Boolean> getBasicConstraints() {
        return this.getExtensions().map(BasicConstraints::fromExtensions).map(BasicConstraints::isCA);
    }

    public List<String> getExtensionOIds() {
        return this.getExtensions().map(extensions -> Arrays.stream(extensions.getExtensionOIDs()).map(ASN1ObjectIdentifier::getId).toList()).orElse(List.of());
    }

    private Optional<Extensions> getExtensions() {
        return Optional.of(this.csr.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)).filter(attributes -> ((Attribute[])attributes).length > 0).map(attributes -> attributes[0]).map(attribute -> Extensions.getInstance((Object)attribute.getAttrValues().getObjectAt(0)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pkcs10Csr pkcs10Csr = (Pkcs10Csr)o;
        return Objects.equals(this.csr, pkcs10Csr.csr);
    }

    public int hashCode() {
        return Objects.hash(this.csr);
    }
}

