/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.tls.AuthorizationMode;
import com.yahoo.security.tls.CapabilityMode;
import com.yahoo.security.tls.ConfigFileBasedTlsContext;
import com.yahoo.security.tls.ConnectionAuthContext;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityOptions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class TransportSecurityUtils {
    private static ConfigFileBasedTlsContext systemTlsContext;
    public static final String CONFIG_FILE_ENVIRONMENT_VARIABLE = "VESPA_TLS_CONFIG_FILE";
    public static final String INSECURE_MIXED_MODE_ENVIRONMENT_VARIABLE = "VESPA_TLS_INSECURE_MIXED_MODE";
    public static final String INSECURE_AUTHORIZATION_MODE_ENVIRONMENT_VARIABLE = "VESPA_TLS_INSECURE_AUTHORIZATION_MODE";
    public static final String CAPABILITIES_ENV_VAR = "VESPA_TLS_CAPABILITIES_ENFORCEMENT_MODE";

    private TransportSecurityUtils() {
    }

    public static boolean isTransportSecurityEnabled() {
        return TransportSecurityUtils.isTransportSecurityEnabled(System.getenv());
    }

    public static boolean isTransportSecurityEnabled(Map<String, String> envVariables) {
        return TransportSecurityUtils.getConfigFile(envVariables).isPresent();
    }

    public static MixedMode getInsecureMixedMode() {
        return TransportSecurityUtils.getInsecureMixedMode(System.getenv());
    }

    public static MixedMode getInsecureMixedMode(Map<String, String> envVariables) {
        return TransportSecurityUtils.getEnvironmentVariable(envVariables, INSECURE_MIXED_MODE_ENVIRONMENT_VARIABLE).map(MixedMode::fromConfigValue).orElse(MixedMode.defaultValue());
    }

    public static AuthorizationMode getInsecureAuthorizationMode() {
        return TransportSecurityUtils.getInsecureAuthorizationMode(System.getenv());
    }

    public static AuthorizationMode getInsecureAuthorizationMode(Map<String, String> envVariables) {
        return TransportSecurityUtils.getEnvironmentVariable(envVariables, INSECURE_AUTHORIZATION_MODE_ENVIRONMENT_VARIABLE).map(AuthorizationMode::fromConfigValue).orElse(AuthorizationMode.defaultValue());
    }

    public static CapabilityMode getCapabilityMode() {
        return TransportSecurityUtils.getEnvironmentVariable(System.getenv(), CAPABILITIES_ENV_VAR).map(CapabilityMode::fromConfigValue).orElse(CapabilityMode.defaultValue());
    }

    public static Optional<Path> getConfigFile() {
        return TransportSecurityUtils.getConfigFile(System.getenv());
    }

    public static Optional<Path> getConfigFile(Map<String, String> envVariables) {
        return TransportSecurityUtils.getEnvironmentVariable(envVariables, CONFIG_FILE_ENVIRONMENT_VARIABLE).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public static Optional<TransportSecurityOptions> getOptions() {
        return TransportSecurityUtils.getOptions(System.getenv());
    }

    public static Optional<TransportSecurityOptions> getOptions(Map<String, String> envVariables) {
        return TransportSecurityUtils.getConfigFile(envVariables).map(TransportSecurityOptions::fromJsonFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<TlsContext> getSystemTlsContext() {
        Class<TransportSecurityUtils> clazz = TransportSecurityUtils.class;
        synchronized (TransportSecurityUtils.class) {
            Path configFile = TransportSecurityUtils.getConfigFile().orElse(null);
            if (configFile == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return Optional.empty();
            }
            if (systemTlsContext == null) {
                systemTlsContext = new SystemTlsContext(configFile);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Optional.of(systemTlsContext);
        }
    }

    public static Optional<ConnectionAuthContext> getConnectionAuthContext(SSLSession s) {
        return Optional.ofNullable((ConnectionAuthContext)s.getValue("vespa.tls.auth.ctx"));
    }

    public static Optional<ConnectionAuthContext> getConnectionAuthContext(SSLEngine e) {
        return TransportSecurityUtils.getConnectionAuthContext(e.getSession());
    }

    public static Optional<ConnectionAuthContext> getConnectionAuthContext(SSLSocket s) {
        return TransportSecurityUtils.getConnectionAuthContext(s.getSession());
    }

    private static Optional<String> getEnvironmentVariable(Map<String, String> environmentVariables, String variableName) {
        return Optional.ofNullable(environmentVariables.get(variableName)).filter(var -> !var.isEmpty());
    }

    private static class SystemTlsContext
    extends ConfigFileBasedTlsContext {
        SystemTlsContext(Path tlsOptionsConfigFile) {
            super(tlsOptionsConfigFile, TransportSecurityUtils.getInsecureAuthorizationMode());
        }

        @Override
        public void close() {
        }
    }
}

