/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;

public class X509CertificateWithKey {
    private final List<X509Certificate> certificate;
    private final PrivateKey privateKey;

    public X509CertificateWithKey(X509Certificate certificate, PrivateKey privateKey) {
        this(List.of(certificate), privateKey);
    }

    public X509CertificateWithKey(List<X509Certificate> certificate, PrivateKey privateKey) {
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    public X509Certificate certificate() {
        return this.certificate.get(0);
    }

    public List<X509Certificate> certificateWithIntermediates() {
        return this.certificate;
    }

    public PrivateKey privateKey() {
        return this.privateKey;
    }
}

