/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.nio.ByteBuffer;

public class BoolResultNode
extends ResultNode {
    public static final int classId = BoolResultNode.registerClass((int)16530, BoolResultNode.class, BoolResultNode::new);
    private boolean value = false;

    public BoolResultNode() {
    }

    public BoolResultNode(boolean value) {
        this.value = value;
    }

    public BoolResultNode setValue(boolean value) {
        this.value = value;
        return this;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        byte v = (byte)(this.value ? 1 : 0);
        buf.putByte(null, v);
    }

    protected void onDeserialize(Deserializer buf) {
        this.value = buf.getByte(null) != 0;
    }

    @Override
    public long getInteger() {
        return this.value ? 1L : 0L;
    }

    @Override
    public double getFloat() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public byte[] getRaw() {
        return ByteBuffer.allocate(8).putLong(this.getInteger()).array();
    }

    @Override
    public void negate() {
        this.value = !this.value;
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        return Long.compare(this.getInteger(), rhs.getInteger());
    }

    public int hashCode() {
        return super.hashCode() + (int)this.getInteger();
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("value", (Object)this.value);
    }

    @Override
    public void set(ResultNode rhs) {
        this.value = rhs.getInteger() > 0L;
    }
}

