/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.treenet.rule;

import com.yahoo.searchlib.treenet.rule.TreeNode;

public abstract class Condition
extends TreeNode {
    private final String leftValue;
    private final String trueLabel;
    private final String falseLabel;

    public Condition(String leftValue, String trueLabel, String falseLabel) {
        this.leftValue = leftValue;
        this.trueLabel = trueLabel;
        this.falseLabel = falseLabel;
    }

    public String getLeftValue() {
        return this.leftValue;
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    @Override
    public final String toRankingExpression() {
        StringBuilder b = new StringBuilder("if (");
        b.append(this.getLeftValue());
        b.append(" ");
        b.append(this.conditionToRankingExpression());
        b.append(", ");
        b.append(this.getParent().getNodes().get(this.getTrueLabel()).toRankingExpression());
        b.append(", ");
        b.append(this.getParent().getNodes().get(this.getFalseLabel()).toRankingExpression());
        b.append(")");
        return b.toString();
    }

    protected abstract String conditionToRankingExpression();
}

