/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.ranking.features.fieldmatch;

import java.util.Arrays;
import java.util.List;

public class Field {
    private final List<Term> terms;

    public Field(String fieldString) {
        this.terms = Arrays.stream(fieldString.split(" ")).map(Term::new).toList();
    }

    public Field(List<Term> terms) {
        this.terms = List.copyOf(terms);
    }

    public List<Term> terms() {
        return this.terms;
    }

    public static class Term {
        private final String value;
        private final float exactness;

        public Term(String value) {
            this(value, 1.0f);
        }

        public Term(String value, float exactness) {
            this.value = value;
            this.exactness = exactness;
        }

        public String value() {
            return this.value;
        }

        public float exactness() {
            return this.exactness;
        }
    }
}

